/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.codecs.lucene90.compressing;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.codecs.TermVectorsFormat;
import org.apache.lucene.ars_nouveau.codecs.TermVectorsReader;
import org.apache.lucene.ars_nouveau.codecs.TermVectorsWriter;
import org.apache.lucene.ars_nouveau.codecs.compressing.CompressionMode;
import org.apache.lucene.ars_nouveau.codecs.lucene90.compressing.Lucene90CompressingTermVectorsReader;
import org.apache.lucene.ars_nouveau.codecs.lucene90.compressing.Lucene90CompressingTermVectorsWriter;
import org.apache.lucene.ars_nouveau.index.FieldInfos;
import org.apache.lucene.ars_nouveau.index.SegmentInfo;
import org.apache.lucene.ars_nouveau.store.Directory;
import org.apache.lucene.ars_nouveau.store.IOContext;

public class Lucene90CompressingTermVectorsFormat
extends TermVectorsFormat {
    private final String formatName;
    private final String segmentSuffix;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int blockSize;
    private final int maxDocsPerChunk;

    public Lucene90CompressingTermVectorsFormat(String formatName, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (chunkSize < 1) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be >= 1");
        }
        this.blockSize = blockSize;
    }

    @Override
    public final TermVectorsReader vectorsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext context) throws IOException {
        return new Lucene90CompressingTermVectorsReader(directory, segmentInfo, this.segmentSuffix, fieldInfos, context, this.formatName, this.compressionMode);
    }

    @Override
    public final TermVectorsWriter vectorsWriter(Directory directory, SegmentInfo segmentInfo, IOContext context) throws IOException {
        return new Lucene90CompressingTermVectorsWriter(directory, segmentInfo, this.segmentSuffix, context, this.formatName, this.compressionMode, this.chunkSize, this.maxDocsPerChunk, this.blockSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + String.valueOf(this.compressionMode) + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockSize=" + this.blockSize + ")";
    }
}

