/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RitualCloudshaper
extends AbstractRitual {
    public static final IntProvider RAIN_DELAY = UniformInt.of((int)12000, (int)180000);
    public static final IntProvider RAIN_DURATION = UniformInt.of((int)12000, (int)24000);
    public static final IntProvider THUNDER_DURATION = UniformInt.of((int)3600, (int)15600);

    @Override
    protected void tick() {
        ParticleUtil.spawnRitualSkyEffect(this, this.tile, this.rand, this.getCenterColor().toWrapper());
        if (this.getWorld().getGameTime() % 20L == 0L && !this.getWorld().isClientSide) {
            this.incrementProgress();
            if (this.getProgress() >= 18) {
                ServerLevel world = (ServerLevel)this.getWorld();
                if (!this.isStorm() && !this.isRain()) {
                    world.setWeatherParameters(RAIN_DELAY.sample(world.getRandom()), 0, false, false);
                    this.setFinished();
                }
                if (this.isStorm()) {
                    world.setWeatherParameters(0, THUNDER_DURATION.sample(world.getRandom()), true, true);
                    this.setFinished();
                }
                if (this.isRain()) {
                    world.setWeatherParameters(0, RAIN_DURATION.sample(world.getRandom()), true, false);
                    this.setFinished();
                }
            }
        }
    }

    public boolean isStorm() {
        return this.didConsumeItem((ItemLike)Items.LAPIS_BLOCK);
    }

    public boolean isRain() {
        return this.didConsumeItem((ItemLike)Items.GUNPOWDER);
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return this.getConsumedItems().isEmpty() && (stack.getItem() == Items.LAPIS_BLOCK || stack.getItem() == Items.GUNPOWDER);
    }

    @Override
    public String getLangName() {
        return "Cloudshaping";
    }

    @Override
    public String getLangDescription() {
        return "This ritual can change the weather at a moments notice. By default, this ritual will set the weather to clear. Augmenting with Gunpowder will cause it to rain, while a Lapis Block will cause it to storm.";
    }

    @Override
    public ParticleColor getCenterColor() {
        return !this.isRain() && !this.isStorm() ? new ParticleColor(this.rand.nextInt(255), this.rand.nextInt(255), this.rand.nextInt(255)) : new ParticleColor(this.rand.nextInt(100), this.rand.nextInt(100), this.rand.nextInt(255));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.CLOUDSHAPER);
    }
}

