/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.data.DominionWandData;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PacketUpdateDominionWand
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketUpdateDominionWand> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("set_wand_mode"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateDominionWand> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, s -> s.slot, PacketUpdateDominionWand::new);
    public int slot;

    public PacketUpdateDominionWand(int slot) {
        this.slot = slot;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ItemStack stack = player.getMainHandItem().getItem() instanceof DominionWand ? player.getMainHandItem() : player.getOffhandItem();
        stack.set(DataComponentRegistry.DOMINION_WAND, (Object)(switch (this.slot) {
            default -> ((DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData())).setFace(null).storeEntity(-1).storePos(null);
            case 1 -> ((DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData())).toggleMode(false);
            case 2 -> ((DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData())).toggleMode(true);
        }));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

