/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.ChimeraSummonEvent;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.common.event.timed.EruptionEvent;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class PacketTimedEvent
extends AbstractPacket {
    CompoundTag tag;
    public static final CustomPacketPayload.Type<PacketTimedEvent> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("timed_event"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketTimedEvent> CODEC = StreamCodec.ofMember(PacketTimedEvent::toBytes, PacketTimedEvent::new);
    public static Map<String, Function<CompoundTag, Void>> methodMap = new HashMap<String, Function<CompoundTag, Void>>();

    public PacketTimedEvent(RegistryFriendlyByteBuf buf) {
        this.tag = buf.readNbt();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
    }

    public PacketTimedEvent(CompoundTag tag) {
        this.tag = tag;
    }

    public PacketTimedEvent(ITimedEvent event) {
        this.tag = new CompoundTag();
        event.serialize(this.tag);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        if (!methodMap.containsKey(this.tag.getString("id"))) {
            throw new IllegalStateException("No event found for ID or ID missing");
        }
        methodMap.get(this.tag.getString("id")).apply(this.tag);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        methodMap.put("chimera", nbt -> ChimeraSummonEvent.get(nbt).onPacketHandled());
        methodMap.put("eruption", nbt -> EruptionEvent.get(nbt).onPacketHandled());
    }
}

