/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record DominionWandData(Optional<GlobalPos> storedPos, Optional<Direction> face, boolean strict, int storedEntityId) {
    public static final int NULL_ENTITY = -1;
    public static Codec<DominionWandData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.optionalFieldOf("pos").forGetter(DominionWandData::storedPos), (App)Direction.CODEC.optionalFieldOf("face").forGetter(DominionWandData::face), (App)Codec.BOOL.fieldOf("strict").forGetter(DominionWandData::strict), (App)Codec.INT.fieldOf("entityId").forGetter(DominionWandData::storedEntityId)).apply((Applicative)instance, DominionWandData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, DominionWandData> STREAM = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC.apply(ByteBufCodecs::optional), DominionWandData::storedPos, (StreamCodec)Direction.STREAM_CODEC.apply(ByteBufCodecs::optional), DominionWandData::face, (StreamCodec)ByteBufCodecs.BOOL, DominionWandData::strict, (StreamCodec)ByteBufCodecs.INT, DominionWandData::getStoredEntity, DominionWandData::new);

    public DominionWandData() {
        this(Optional.empty(), Optional.empty(), false, -1);
    }

    public boolean hasStoredData() {
        return this.storedPos.isPresent() || this.storedEntityId != -1;
    }

    @Nullable
    public GlobalPos getValidPos() {
        return this.storedPos.orElse(null);
    }

    public int getStoredEntity() {
        return this.storedEntityId == 0 || this.storedEntityId == -1 ? -1 : this.storedEntityId;
    }

    public DominionWandData storePos(@Nullable GlobalPos pos) {
        return new DominionWandData(pos == null ? Optional.empty() : Optional.of(new GlobalPos(pos.dimension(), pos.pos().immutable())), this.face, this.strict, this.storedEntityId);
    }

    public DominionWandData storeEntity(int entityId) {
        return new DominionWandData(this.storedPos, this.face, this.strict, entityId);
    }

    public DominionWandData setFace(@Nullable Direction face) {
        return new DominionWandData(this.storedPos, Optional.ofNullable(face), this.strict, this.storedEntityId);
    }

    @Deprecated(forRemoval=true)
    public DominionWandData toggleMode() {
        return new DominionWandData(this.storedPos, this.face, !this.strict, this.storedEntityId);
    }

    public DominionWandData toggleMode(boolean strict) {
        return new DominionWandData(this.storedPos, this.face, strict, this.storedEntityId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DominionWandData that = (DominionWandData)o;
        return this.strict == that.strict && this.storedEntityId == that.storedEntityId && this.face == that.face && Objects.equals(this.storedPos, that.storedPos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.storedPos, this.face, this.strict, this.storedEntityId);
    }
}

