/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.common.items.ModItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public abstract class ExperienceGem
extends ModItem {
    public ExperienceGem(Item.Properties properties) {
        super(properties);
    }

    public ExperienceGem() {
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player playerEntity, InteractionHand hand) {
        if (!world.isClientSide) {
            if (playerEntity.isCrouching()) {
                int val = this.getValue() * playerEntity.getItemInHand(hand).getCount();
                if ((val = this.repairPlayerItems(playerEntity, val, val)) > 0) {
                    playerEntity.giveExperiencePoints(val);
                }
                if (!playerEntity.hasInfiniteMaterials()) {
                    playerEntity.getItemInHand(hand).shrink(playerEntity.getItemInHand(hand).getCount());
                }
            } else {
                int val = this.getValue();
                if ((val = this.repairPlayerItems(playerEntity, val, val)) > 0) {
                    playerEntity.giveExperiencePoints(val);
                }
                if (!playerEntity.hasInfiniteMaterials()) {
                    playerEntity.getItemInHand(hand).shrink(1);
                }
            }
        }
        return InteractionResultHolder.pass((Object)playerEntity.getItemInHand(hand));
    }

    public int repairPlayerItems(Player p_147093_, int remainingExp, int initialValue) {
        EnchantedItemInUse entry = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)p_147093_, ItemStack::isDamaged).orElse(null);
        if (entry != null) {
            ItemStack itemstack = entry.itemStack();
            int i = Math.min((int)((float)initialValue * itemstack.getXpRepairRatio()), itemstack.getDamageValue());
            itemstack.setDamageValue(itemstack.getDamageValue() - i);
            int j = remainingExp - this.durabilityToXp(i);
            return j > 0 ? this.repairPlayerItems(p_147093_, j, initialValue) : 0;
        }
        return remainingExp;
    }

    public int durabilityToXp(int pDurability) {
        return pDurability / 2;
    }

    public abstract int getValue();
}

