/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.common.items.data.ReactiveCasterData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketReactiveSpell;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class ReactiveEvents {
    @SubscribeEvent
    public static void livingHitEvent(LivingDamageEvent.Post e) {
        LivingEntity entity = e.getEntity();
        if (entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        for (ItemStack s : entity.getArmorSlots()) {
            ReactiveEvents.castSpell(entity, s);
        }
    }

    public static void castSpell(LivingEntity playerIn, ItemStack stack) {
        int level = stack.getEnchantmentLevel(playerIn.level.holderOrThrow(EnchantmentRegistry.REACTIVE_ENCHANTMENT));
        ReactiveCasterData reactiveCaster = (ReactiveCasterData)stack.get(DataComponentRegistry.REACTIVE_CASTER);
        if ((double)level * 0.25 >= Math.random() && reactiveCaster != null && reactiveCaster.getSpell().isValid()) {
            reactiveCaster.castSpell(playerIn.getCommandSenderWorld(), playerIn, InteractionHand.MAIN_HAND, null);
        }
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock e) {
        Player entity = e.getEntity();
        if (entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        ItemStack s = e.getItemStack();
        ReactiveEvents.castSpell((LivingEntity)entity, s);
    }

    @SubscribeEvent
    public static void playerAttackEntity(AttackEntityEvent e) {
        Player entity = e.getEntity();
        if (entity == null || entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        ItemStack s = e.getEntity().getMainHandItem();
        ReactiveEvents.castSpell((LivingEntity)entity, s);
    }

    @SubscribeEvent
    public static void leftClickAir(PlayerInteractEvent.LeftClickEmpty e) {
        if (e.getItemStack().getEnchantmentLevel(HolderHelper.unwrap(e.getLevel(), EnchantmentRegistry.REACTIVE_ENCHANTMENT)) > 0) {
            Networking.sendToServer(new PacketReactiveSpell());
        }
    }
}

