/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ChimeraSpikeGoal
extends Goal {
    WildenChimera boss;
    boolean finished;
    int ticks;

    public ChimeraSpikeGoal(WildenChimera boss) {
        this.boss = boss;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void start() {
        this.finished = false;
        this.ticks = 0;
    }

    public void stop() {
        super.stop();
        this.tearDownGoal();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        super.tick();
        ++this.ticks;
        this.boss.setDefensiveMode(true);
        this.boss.setDeltaMovement(0.0, 0.0, 0.0);
        if (this.ticks % 20 == 0) {
            ChimeraSpikeGoal.spawnAOESpikes(this.boss);
            for (int i = 0; i < 3; ++i) {
                if (this.boss.getTarget() == null) continue;
                EntityChimeraProjectile abstractarrowentity = new EntityChimeraProjectile(this.boss.level);
                abstractarrowentity.setPos(this.boss.getX(), this.boss.getY(), this.boss.getZ());
                double d0 = this.boss.getTarget().getX() - this.boss.getX();
                double d1 = this.boss.getTarget().getY(0.3333333333333333) - abstractarrowentity.getY();
                double d2 = this.boss.getTarget().getZ() - this.boss.getZ();
                double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
                abstractarrowentity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
                this.boss.level.addFreshEntity((Entity)abstractarrowentity);
            }
        }
        if (this.ticks >= 120) {
            this.finished = true;
            this.boss.spikeCooldown = (int)(500.0 + ParticleUtil.inRange(-100.0, 100.0) + (double)this.boss.getCooldownModifier());
            this.tearDownGoal();
        }
    }

    public static void spawnAOESpikes(WildenChimera boss) {
        for (int i = 0; i < 100; ++i) {
            EntityChimeraProjectile entity = new EntityChimeraProjectile(boss.level);
            entity.shootFromRotation((Entity)boss, boss.level.random.nextInt(360), boss.level.random.nextInt(360), 0.0f, (float)(1.0 + ParticleUtil.inRange(0.0, 0.5)), 1.0f);
            entity.setPos(boss.position.x, boss.position.y + 2.0, boss.position.z);
            boss.level.addFreshEntity((Entity)entity);
        }
    }

    public void tearDownGoal() {
        this.boss.setDefensiveMode(false);
    }

    public boolean canContinueToUse() {
        boolean canContinue;
        boolean bl = canContinue = !this.finished && !this.boss.getPhaseSwapping();
        if (!canContinue) {
            this.tearDownGoal();
        }
        return canContinue;
    }

    public boolean canUse() {
        return this.boss.canSpike();
    }
}

