/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.api.registry.PotionProviderRegistry;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class PotionFlaskRecipe
extends ShapelessRecipe {
    public PotionFlaskRecipe(String groupIn, ItemStack result, ItemStack recipeOutputIn) {
        super(groupIn, CraftingBookCategory.MISC, recipeOutputIn, NonNullList.copyOf(List.of(Ingredient.of((ItemStack[])new ItemStack[]{result}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTION}))));
    }

    public PotionFlaskRecipe(String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(pGroup, pCategory, pResult, pIngredients);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider p_266797_) {
        ItemStack output = super.assemble(inv, p_266797_);
        if (output.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack flaskPotionStack = ItemStack.EMPTY;
        ItemStack potionStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item instanceof PotionFlask) {
                PotionFlask flask = (PotionFlask)item;
                flaskPotionStack = stack.copy();
                IPotionProvider provider = PotionProviderRegistry.from(flaskPotionStack);
                if (provider == null || provider.roomLeft(flaskPotionStack) <= 0) {
                    return ItemStack.EMPTY;
                }
            }
            if (!(stack.getItem() instanceof PotionItem)) continue;
            potionStack = stack;
        }
        if (flaskPotionStack.isEmpty() || potionStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IPotionProvider provider = PotionProviderRegistry.from(flaskPotionStack);
        PotionContents potionData = (PotionContents)potionStack.get(DataComponents.POTION_CONTENTS);
        if (provider == null) {
            return ItemStack.EMPTY;
        }
        int count = provider.usesRemaining(flaskPotionStack);
        ItemStack copyStack = flaskPotionStack.copy();
        if (count <= 0) {
            provider.setData(potionData, 1, provider.maxUses(flaskPotionStack), copyStack);
            return copyStack;
        }
        if (PotionUtil.arePotionContentsEqual(potionData, provider.getPotionData(potionStack))) {
            provider.setData(potionData, count + 1, provider.maxUses(flaskPotionStack), copyStack);
            return copyStack;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)item.getCraftingRemainingItem());
                continue;
            }
            if (!(item.getItem() instanceof PotionItem)) continue;
            nonnulllist.set(i, (Object)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.POTION_FLASK_RECIPE.get();
    }
}

