/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.command;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.capability.FamiliarData;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ResetCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ars-reset").requires(sender -> sender.hasPermission(2))).executes(context -> ResetCommand.resetPlayers((CommandSourceStack)context.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)context.getSource()).getEntityOrException())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context -> ResetCommand.resetPlayers((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets")))));
    }

    private static int resetPlayers(CommandSourceStack source, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            ANPlayerDataCap playerCap;
            if (!(entity instanceof LivingEntity)) continue;
            ManaCap iMana = CapabilityRegistry.getMana((LivingEntity)entity);
            if (iMana != null) {
                iMana.setBookTier(0);
                iMana.setGlyphBonus(0);
            }
            if ((playerCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)entity)) == null) continue;
            playerCap.setKnownGlyphs(new ArrayList<AbstractSpellPart>());
            playerCap.setUnlockedFamiliars(new ArrayList<FamiliarData>());
        }
        source.sendSuccess(() -> Component.translatable((String)"ars_nouveau.reset.cleared"), true);
        return 1;
    }
}

