/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli;

import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class EnchantmentProcessor
implements IComponentProcessor {
    RecipeHolder<? extends EnchantmentRecipe> recipe;

    public void setup(Level level, IVariableProvider variables) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        String recipeID = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        this.recipe = manager.byKey(ResourceLocation.tryParse((String)recipeID)).orElse(null);
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        EnchantmentRecipe enchant = (EnchantmentRecipe)this.recipe.value();
        if (key.equals("enchantment")) {
            Holder enchantment = level.holderOrThrow(enchant.enchantmentKey);
            return IVariable.wrap((String)((Enchantment)enchantment.value()).description().getString(), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("level")) {
            return IVariable.wrap((Number)enchant.enchantLevel);
        }
        if (key.startsWith("item")) {
            int index = Integer.parseInt(key.substring(4)) - 1;
            if (enchant.pedestalItems().size() <= index) {
                return IVariable.from((Object)ItemStack.EMPTY, (HolderLookup.Provider)level.registryAccess());
            }
            Ingredient ingredient = enchant.pedestalItems().get(Integer.parseInt(key.substring(4)) - 1);
            return IVariable.wrapList((Iterable)Arrays.stream(ingredient.getItems()).map(i -> IVariable.from((Object)i, (HolderLookup.Provider)level.registryAccess())).collect(Collectors.toList()), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

