/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.PropParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FallingParticle
extends PropParticle {
    public Fluid type;
    public SoundEvent landingSound;

    protected FallingParticle(PropertyParticleOptions options, ClientLevel level, double x, double y, double z) {
        super(options, level, x, y, z);
    }

    public FallingParticle(PropertyParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(options, level, x, y, z, xSpeed, ySpeed, zSpeed);
        float scale = 0.5f;
        this.xd *= (double)scale;
        this.yd *= (double)scale;
        this.zd *= (double)scale;
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.03f;
        this.lifetime = 20;
    }

    @Override
    @Nullable
    public ParticleColor getDefaultColor() {
        return ParticleColor.BLUE;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                BlockPos blockpos;
                FluidState fluidstate;
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
                if (this.type != Fluids.EMPTY && (fluidstate = this.level.getFluidState(blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z))).getType() == this.type && this.y < (double)((float)blockpos.getY() + fluidstate.getHeight((BlockGetter)this.level, blockpos))) {
                    this.remove();
                }
            }
        }
    }

    protected void postMoveUpdate() {
        if (this.onGround && this.landingSound != null) {
            this.remove();
            if (this.random.nextDouble() > 0.5) {
                float f = Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f);
                this.level.playLocalSound(this.x, this.y, this.z, this.landingSound, SoundSource.NEUTRAL, f, 1.0f, false);
            }
        }
    }

    @Override
    public boolean tinted() {
        return true;
    }
}

