/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.client.gui.buttons.PropertyButton;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;

public class PropWidgetList {
    List<PropertyButton> allButtons = new ArrayList<PropertyButton>();
    Consumer<PropertyButton> onPropertySelected;
    Consumer<PropertyButton> onDepenciesChanged;
    int propLeftPageOffset;
    int propRightPageOffset;
    int propTopOffset;
    private int topSelectedIndex = -1;

    public PropWidgetList(int propLeftPageOffset, int propRightPageOffset, int propTopOffset, Consumer<PropertyButton> onPropertySelected, Consumer<PropertyButton> onDepenciesChanged, @Nullable PropWidgetList oldTree) {
        this.propLeftPageOffset = propLeftPageOffset;
        this.propRightPageOffset = propRightPageOffset;
        this.propTopOffset = propTopOffset;
        this.onPropertySelected = onPropertySelected;
        this.onDepenciesChanged = onDepenciesChanged;
        if (oldTree != null) {
            this.topSelectedIndex = oldTree.topSelectedIndex;
        }
    }

    public void resetSelected() {
        this.topSelectedIndex = -1;
    }

    public void init(List<BaseProperty<?>> props) {
        PropertyButton selectedButton;
        this.allButtons = this.getPropButtons(props, 0);
        if (this.topSelectedIndex != -1 && this.topSelectedIndex < this.allButtons.size() && (selectedButton = this.allButtons.get(this.topSelectedIndex)) != null) {
            selectedButton.setExpanded(true);
            selectedButton.isSelected = true;
        }
    }

    @Nullable
    public PropertyButton getSelectedButton() {
        if (this.topSelectedIndex >= 0 && this.topSelectedIndex < this.allButtons.size()) {
            return this.allButtons.get(this.topSelectedIndex);
        }
        return null;
    }

    public List<PropertyButton> getPropButtons(List<BaseProperty<?>> props, int depth) {
        ArrayList<PropertyButton> buttons = new ArrayList<PropertyButton>();
        if (depth > 3) {
            return buttons;
        }
        for (BaseProperty<?> property : props) {
            PropertyButton propertyButton = this.buildPropertyButton(property, depth);
            buttons.add(propertyButton);
            List<PropertyButton> childrenButtons = this.getPropButtons(property.subProperties(), depth + 1);
            propertyButton.setChildren(new ArrayList<PropertyButton>(childrenButtons));
            buttons.addAll(childrenButtons);
        }
        int i = 0;
        while (i < buttons.size()) {
            PropertyButton propButton = (PropertyButton)buttons.get(i);
            propButton.index = i++;
            propButton.property.setChangedListener(() -> {
                propButton.setChildren(this.getPropButtons(propButton.property.subProperties(), propButton.nestLevel + 1));
                this.onDepenciesChanged.accept(propButton);
            });
        }
        return buttons;
    }

    private PropertyButton buildPropertyButton(BaseProperty<?> property, int nestLevel) {
        DocAssets.BlitInfo texture = DocAssets.DOUBLE_NESTED_ENTRY_BUTTON;
        DocAssets.BlitInfo selectedTexture = DocAssets.DOUBLE_NESTED_ENTRY_BUTTON_SELECTED;
        switch (nestLevel) {
            case 0: {
                texture = DocAssets.NESTED_ENTRY_BUTTON;
                selectedTexture = DocAssets.NESTED_ENTRY_BUTTON_SELECTED;
                break;
            }
            case 1: {
                texture = DocAssets.DOUBLE_NESTED_ENTRY_BUTTON;
                selectedTexture = DocAssets.DOUBLE_NESTED_ENTRY_BUTTON_SELECTED;
                break;
            }
            case 2: {
                texture = DocAssets.TRIPLE_NESTED_ENTRY_BUTTON;
                selectedTexture = DocAssets.TRIPLE_NESTED_ENTRY_BUTTON_SELECTED;
                break;
            }
        }
        ParticleConfigWidgetProvider widgetProvider = property.buildWidgets(this.propRightPageOffset, this.propTopOffset, 118, 146);
        PropertyButton propButton = new PropertyButton(this.propLeftPageOffset + nestLevel * 13, 0, texture, selectedTexture, property, widgetProvider, nestLevel, b -> this.onPropertySelected((PropertyButton)b));
        return propButton;
    }

    private void onPropertySelected(PropertyButton propertyButton) {
        for (AbstractWidget abstractWidget : this.allButtons) {
            if (!(abstractWidget instanceof PropertyButton)) continue;
            PropertyButton button = (PropertyButton)abstractWidget;
            button.setExpanded(false);
            button.isSelected = false;
        }
        propertyButton.setExpanded(true);
        propertyButton.isSelected = true;
        this.topSelectedIndex = propertyButton.index;
        this.onPropertySelected.accept(propertyButton);
    }
}

