/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.ClearButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.FamiliarButton;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketDispelFamiliars;
import com.hollingsworth.arsnouveau.common.network.PacketSummonFamiliar;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GuiFamiliarScreen
extends BaseBook {
    public List<AbstractFamiliarHolder> familiars;
    public Screen parent;

    public GuiFamiliarScreen(List<AbstractFamiliarHolder> familiars, Screen parent) {
        this.familiars = familiars;
        this.parent = parent;
    }

    @Override
    public void init() {
        super.init();
        this.addBackButton(this.parent);
        int xStart = this.bookLeft + 20;
        int yStart = this.bookTop + 34;
        int PER_ROW = 6;
        int toLayout = Math.min(this.familiars.size(), 30);
        for (int i = 0; i < toLayout; ++i) {
            AbstractFamiliarHolder part = this.familiars.get(i);
            int xOffset = 20 * (i % 6);
            int yOffset = i / 6 * 18;
            FamiliarButton cell = new FamiliarButton(xStart + xOffset, yStart + yOffset, part, this::onFamiliarClicked);
            this.addRenderableWidget((GuiEventListener)cell);
        }
        this.addRenderableWidget((GuiEventListener)new ClearButton(this.bookRight - 71, this.bookBottom - 13, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.dispel"), e -> Networking.sendToServer(new PacketDispelFamiliars())));
        this.addRenderableWidget((GuiEventListener)new ClearButton(this.bookRight - 131, this.bookBottom - 13, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.close"), e -> Minecraft.getInstance().setScreen(null)));
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.familiar").getString(), 20, 24, -8355712, false);
    }

    public void onFamiliarClicked(Button button) {
        FamiliarButton button1 = (FamiliarButton)button;
        Networking.sendToServer(new PacketSummonFamiliar(button1.familiarHolder.getRegistryName()));
        Minecraft.getInstance().setScreen(null);
    }
}

