/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.ANEventBus;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BlockUtil {
    public static BlockPos toPos(Vec3 vec) {
        return BlockPos.containing((double)vec.x, (double)vec.y, (double)vec.z);
    }

    public static boolean isTreeBlock(BlockState block) {
        return block.is(BlockTags.LEAVES) || block.is(BlockTags.LOGS);
    }

    public static boolean containsStateInRadius(Level world, BlockPos start, int radius, Class clazz) {
        for (double x = (double)(start.getX() - radius); x <= (double)(start.getX() + radius); x += 1.0) {
            for (double y = (double)(start.getY() - radius); y <= (double)(start.getY() + radius); y += 1.0) {
                for (double z = (double)(start.getZ() - radius); z <= (double)(start.getZ() + radius); z += 1.0) {
                    BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                    if (pos.equals((Object)start) || !world.getBlockState(pos).getBlock().getClass().equals(clazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double distanceFrom(BlockPos start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.getX() - end.getX(), 2.0) + Math.pow(start.getY() - end.getY(), 2.0) + Math.pow(start.getZ() - end.getZ(), 2.0));
    }

    public static double distanceFromCenter(BlockPos start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return BlockUtil.distanceFrom(new Vec3((double)start.getX() + 0.5, (double)start.getY() + 0.5, (double)start.getZ() + 0.5), new Vec3((double)end.getX() + 0.5, (double)end.getY() + 0.5, (double)end.getZ() + 0.5));
    }

    public static double distanceFrom(Vec3 start, BlockPos end) {
        if (start == null || end == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(start.x - (double)end.getX(), 2.0) + Math.pow(start.y - (double)end.getY(), 2.0) + Math.pow(start.z - (double)end.getZ(), 2.0));
    }

    public static double distanceFrom(Vec3 start, Vec3 end) {
        return Math.sqrt(Math.pow(start.x - end.x, 2.0) + Math.pow(start.y - end.y, 2.0) + Math.pow(start.z - end.z, 2.0));
    }

    public static boolean destroyBlockSafely(Level world, BlockPos pos, boolean dropBlock, LivingEntity caster) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        Player playerEntity = ANFakePlayer.getOrFakePlayer(serverLevel, caster);
        if (ANEventBus.post(new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), playerEntity))) {
            return false;
        }
        world.getBlockState(pos).getBlock().playerWillDestroy(world, pos, world.getBlockState(pos), playerEntity);
        return world.destroyBlock(pos, dropBlock);
    }

    public static boolean destroyRespectsClaim(LivingEntity caster, Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        Player playerEntity = ANFakePlayer.getOrFakePlayer(serverLevel, caster);
        return !ANEventBus.post(new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), playerEntity));
    }

    public static void safelyUpdateState(Level world, BlockPos pos, BlockState state) {
        if (!world.isOutsideBuildHeight(pos)) {
            world.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public static void safelyUpdateState(Level world, BlockPos pos) {
        BlockUtil.safelyUpdateState(world, pos, world.getBlockState(pos));
    }

    @Deprecated
    public static boolean destroyBlockSafelyWithoutSound(Level world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    public static boolean destroyBlockSafelyWithoutSound(Level world, BlockPos pos, boolean dropBlock, LivingEntity caster) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        Player playerEntity = ANFakePlayer.getOrFakePlayer(serverLevel, caster);
        if (ANEventBus.post(new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), playerEntity))) {
            return false;
        }
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, (LivingEntity)playerEntity);
    }

    @Deprecated
    private static boolean destroyBlockWithoutSound(Level world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    private static boolean destroyBlockWithoutSound(Level world, BlockPos pos, boolean isMoving, LivingEntity entityIn) {
        BlockState blockstate = world.getBlockState(pos);
        if (blockstate.isAir()) {
            return false;
        }
        FluidState ifluidstate = world.getFluidState(pos);
        if (isMoving) {
            BlockEntity tileentity = blockstate.hasBlockEntity() ? world.getBlockEntity(pos) : null;
            Block.dropResources((BlockState)blockstate, (Level)world, (BlockPos)pos, (BlockEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.EMPTY);
        }
        return world.setBlock(pos, ifluidstate.createLegacyBlock(), 3);
    }

    public static List<IItemHandler> getAdjacentInventories(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return new ArrayList<IItemHandler>();
        }
        ArrayList<IItemHandler> iInventories = new ArrayList<IItemHandler>();
        for (Direction d : Direction.values()) {
            IItemHandler cap = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos.relative(d), null);
            if (cap == null) continue;
            iInventories.add(cap);
        }
        return iInventories;
    }

    public static ItemStack insertItemAdjacent(Level world, BlockPos pos, ItemStack stack) {
        for (IItemHandler i : BlockUtil.getAdjacentInventories(world, pos)) {
            if (stack == ItemStack.EMPTY || stack == null) break;
            stack = ItemHandlerHelper.insertItemStacked((IItemHandler)i, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack getItemAdjacent(Level world, BlockPos pos, Predicate<ItemStack> matchPredicate) {
        ItemStack stack = ItemStack.EMPTY;
        for (IItemHandler inv : BlockUtil.getAdjacentInventories(world, pos)) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!matchPredicate.test(inv.getStackInSlot(i))) continue;
                return inv.getStackInSlot(i);
            }
        }
        return stack;
    }

    public static boolean canBlockBeHarvested(SpellStats stats, Level world, BlockPos pos) {
        return world.getBlockState(pos).getDestroySpeed((BlockGetter)world, pos) >= 0.0f && SpellUtil.isCorrectHarvestLevel(BlockUtil.getBaseHarvestLevel(stats), world.getBlockState(pos));
    }

    public static int getBaseHarvestLevel(SpellStats stats) {
        return (int)(3.0 + stats.getAmpMultiplier());
    }

    public static List<BlockPos> getLine(int x0, int y0, int x1, int y1, float wd) {
        ArrayList<BlockPos> vects = new ArrayList<BlockPos>();
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        float ed = dx + dy == 0 ? 1.0f : Mth.sqrt((float)((float)dx * (float)dx + (float)dy * (float)dy));
        wd = (wd + 1.0f) / 2.0f;
        while (true) {
            vects.add(new BlockPos(x0, 0, y0));
            int e2 = err;
            int x2 = x0;
            if (2 * e2 >= -dx) {
                e2 += dy;
                int y2 = y0;
                while ((float)e2 < ed * wd && (y1 != y2 || dx > dy)) {
                    vects.add(new BlockPos(x0, 0, y2 += sy));
                    e2 += dx;
                }
                if (x0 == x1) break;
                e2 = err;
                err -= dy;
                x0 += sx;
            }
            if (2 * e2 > dy) continue;
            e2 = dx - e2;
            while ((float)e2 < ed * wd && (x1 != x2 || dx < dy)) {
                vects.add(new BlockPos(x2 += sx, 0, y0));
                e2 += dy;
            }
            if (y0 == y1) break;
            err += dx;
            y0 += sy;
        }
        return vects;
    }

    @Nullable
    public static BlockPos scanForBlockNearPoint(Level world, BlockPos point, int radiusX, int radiusY, int radiusZ, int height) {
        BlockPos closestCoords = null;
        double minDistance = Double.MAX_VALUE;
        for (int j = point.getY(); j <= point.getY() + radiusY; ++j) {
            for (int i = point.getX() - radiusX; i <= point.getX() + radiusX; ++i) {
                for (int k = point.getZ() - radiusZ; k <= point.getZ() + radiusZ; ++k) {
                    BlockPos tempCoords;
                    if (!BlockUtil.wontSuffocate(world, i, j, k, height) || !world.getBlockState((tempCoords = new BlockPos(i, j, k)).below()).isSolid() && !world.getBlockState(tempCoords.below(2)).isSolid()) continue;
                    double distance = BlockUtil.getDistanceSquared(tempCoords, point);
                    if (closestCoords != null && !(distance < minDistance)) continue;
                    closestCoords = tempCoords;
                    minDistance = distance;
                }
            }
        }
        return closestCoords;
    }

    private static boolean wontSuffocate(Level world, int x, int y, int z, int height) {
        for (int dy = 0; dy < height; ++dy) {
            BlockState state = world.getBlockState(new BlockPos(x, y + dy, z));
            if (!state.blocksMotion()) continue;
            return false;
        }
        return true;
    }

    public static long getDistanceSquared(BlockPos block1, BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.getX() - (long)block2.getX();
        long result = xDiff * xDiff + (yDiff = (long)block1.getY() - (long)block2.getY()) * yDiff + (zDiff = (long)block1.getZ() - (long)block2.getZ()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static void updateObservers(Level level, BlockPos pos) {
        for (Direction d : Direction.values()) {
            BlockState observer;
            BlockPos adjacentPos = pos.relative(d);
            if (!(level.getBlockState(adjacentPos).getBlock() instanceof ObserverBlock) || !adjacentPos.relative((Direction)(observer = level.getBlockState(adjacentPos)).getValue((Property)ObserverBlock.FACING)).equals((Object)pos)) continue;
            level.scheduleTick(pos.relative(d), level.getBlockState(pos.relative(d)).getBlock(), 2);
        }
    }

    public static boolean breakExtraBlock(ServerLevel level, BlockPos pos, ItemStack mainhand, @Nullable UUID source, boolean bypassTool) {
        String username;
        BlockState state = level.getBlockState(pos);
        ANFakePlayer player = ANFakePlayer.getPlayer(level);
        if (source != null && (username = UsernameCache.getLastKnownUsername((UUID)source)) != null) {
            player = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(source, username));
            Player realPlayer = level.getPlayerByUUID(source);
            if (realPlayer != null) {
                player.setPos(realPlayer.position());
            }
        }
        player.getInventory().items.set(player.getInventory().selected, (Object)mainhand);
        if (!(bypassTool || !(state.getDestroySpeed((BlockGetter)level, pos) < 0.0f) && state.canHarvestBlock((BlockGetter)level, pos, (Player)player))) {
            return false;
        }
        GameType type = player.getAbilities().instabuild ? GameType.CREATIVE : GameType.SURVIVAL;
        BlockEvent.BreakEvent exp = CommonHooks.fireBlockBreak((Level)level, (GameType)type, (ServerPlayer)player, (BlockPos)pos, (BlockState)state);
        if (exp.isCanceled()) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Block block = state.getBlock();
        if (block instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
            level.sendBlockUpdated(pos, state, state, 3);
            return false;
        }
        if (player.blockActionRestricted((Level)level, pos, type)) {
            return false;
        }
        BlockState newState = block.playerWillDestroy((Level)level, pos, state, (Player)player);
        if (player.getAbilities().instabuild) {
            BlockUtil.removeBlock(level, (ServerPlayer)player, pos, newState, false);
            return true;
        }
        ItemStack tool = player.getMainHandItem();
        ItemStack toolCopy = tool.copy();
        boolean canHarvest = bypassTool || newState.canHarvestBlock((BlockGetter)level, pos, (Player)player);
        tool.mineBlock((Level)level, newState, pos, (Player)player);
        boolean removed = BlockUtil.removeBlock(level, (ServerPlayer)player, pos, newState, canHarvest);
        if (canHarvest && removed) {
            block.playerDestroy((Level)level, (Player)player, pos, newState, blockEntity, toolCopy);
        }
        if (tool.isEmpty() && !toolCopy.isEmpty()) {
            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)toolCopy, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        return true;
    }

    public static boolean removeBlock(ServerLevel level, ServerPlayer player, BlockPos pos, BlockState state, boolean canHarvest) {
        boolean removed = state.onDestroyedByPlayer((Level)level, pos, (Player)player, canHarvest, level.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)level, pos, state);
        }
        return removed;
    }

    private BlockUtil() {
    }
}

