/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class Spell {
    public static final MapCodec<Spell> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(s -> s.name), (App)ParticleColor.CODEC.fieldOf("color").forGetter(s -> s.color), (App)ConfiguredSpellSound.CODEC.fieldOf("sound").forGetter(s -> s.sound), (App)Codec.list(AbstractSpellPart.CODEC).fieldOf("recipe").forGetter(s -> s.recipe), (App)TimelineMap.CODEC.optionalFieldOf("particleTimeline").forGetter(s -> Optional.ofNullable(s.particleTimeline))).apply((Applicative)instance, Spell::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Spell> STREAM = StreamCodec.of((buf, val) -> {
        buf.writeUtf(val.name);
        ParticleColor.STREAM.encode(buf, (Object)val.color);
        ConfiguredSpellSound.STREAM.encode(buf, (Object)val.sound);
        AbstractSpellPart.STREAM_LIST.encode(buf, val.recipe);
        TimelineMap.STREAM.encode(buf, (Object)val.particleTimeline);
    }, buf -> {
        String name = buf.readUtf();
        ParticleColor color = (ParticleColor)ParticleColor.STREAM.decode(buf);
        ConfiguredSpellSound sound = (ConfiguredSpellSound)ConfiguredSpellSound.STREAM.decode(buf);
        List recipe = (List)AbstractSpellPart.STREAM_LIST.decode(buf);
        TimelineMap particleTimeline = (TimelineMap)TimelineMap.STREAM.decode(buf);
        return new Spell(name, color, sound, (List<AbstractSpellPart>)recipe, particleTimeline);
    });
    private final List<AbstractSpellPart> recipe;
    private final String name;
    private final ParticleColor color;
    private final ConfiguredSpellSound sound;
    private final TimelineMap particleTimeline;

    public Spell() {
        this("", ParticleColor.defaultParticleColor(), ConfiguredSpellSound.DEFAULT, (List<AbstractSpellPart>)ImmutableList.of(), new TimelineMap());
    }

    public Spell(AbstractSpellPart ... spellParts) {
        this(Arrays.asList(spellParts));
    }

    public Spell(List<AbstractSpellPart> recipe, String name) {
        this(name, ParticleColor.defaultParticleColor(), ConfiguredSpellSound.DEFAULT, recipe);
    }

    public Spell(List<AbstractSpellPart> recipe) {
        this("", ParticleColor.defaultParticleColor(), ConfiguredSpellSound.DEFAULT, recipe, new TimelineMap());
    }

    @Deprecated(forRemoval=true)
    public Spell(String name, ParticleColor color, ConfiguredSpellSound configuredSpellSound, List<AbstractSpellPart> abstractSpellParts) {
        this(name, color, configuredSpellSound, abstractSpellParts, new TimelineMap());
    }

    public Spell(String name, ParticleColor color, ConfiguredSpellSound configuredSpellSound, List<AbstractSpellPart> abstractSpellParts, TimelineMap particleTimeline) {
        this.name = name;
        this.color = color;
        this.sound = configuredSpellSound;
        this.recipe = ImmutableList.copyOf(abstractSpellParts);
        this.particleTimeline = particleTimeline;
    }

    public Spell(String name, ParticleColor color, ConfiguredSpellSound configuredSpellSound, List<AbstractSpellPart> abstractSpellParts, Optional<TimelineMap> particleTimeline) {
        this(name, color, configuredSpellSound, abstractSpellParts, particleTimeline.orElseGet(TimelineMap::new));
    }

    public static Spell fromJson(String jsonString) {
        try {
            System.out.println("About to read full spell from JSON: " + jsonString);
            Spell spell = (Spell)CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)jsonString)).getOrThrow();
            System.out.println("Full decoded spell: " + String.valueOf(spell));
            return spell;
        }
        catch (Exception e) {
            System.out.println("Failed to read spell from JSON: " + e.getMessage());
            return new Spell();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Spell fromBinaryBase64(String base64) {
        try {
            byte[] bytes = Base64.getDecoder().decode(base64);
            try (GZIPInputStream gzipInput = new GZIPInputStream(new ByteArrayInputStream(bytes));){
                Spell spell;
                try (StringWriter stringWriter = new StringWriter();){
                    IOUtils.copy((InputStream)gzipInput, (Writer)stringWriter, (Charset)StandardCharsets.UTF_8);
                    spell = Spell.fromJson(stringWriter.toString());
                }
                return spell;
            }
            catch (IOException e) {
                System.out.println("Error reading spell from binary: " + e.getMessage());
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("Error decoding base64 string: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error reading spell from binary: " + e.getMessage());
        }
        return new Spell();
    }

    public String toJson() {
        JsonElement json = (JsonElement)CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow();
        Gson gson = new GsonBuilder().create();
        return gson.toJson(json);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String toBinaryBase64() {
        String json = this.toJson();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (GZIPOutputStream gzipOutput = new GZIPOutputStream(baos);){
                gzipOutput.write(json.getBytes(StandardCharsets.UTF_8));
                gzipOutput.finish();
                string = new String(Base64.getEncoder().encode(baos.toByteArray()));
            }
            return string;
        }
        catch (IOException e) {
            System.out.println("Error writing spell to binary: " + e.getMessage());
            return "";
        }
    }

    @Deprecated(forRemoval=true)
    public ConfiguredSpellSound sound() {
        return this.sound;
    }

    public Iterable<AbstractSpellPart> recipe() {
        return this.recipe;
    }

    public List<AbstractSpellPart> unsafeList() {
        return this.recipe;
    }

    public AbstractSpellPart get(int index) {
        return this.recipe.get(index);
    }

    public int size() {
        return this.recipe.size();
    }

    public int indexOf(AbstractSpellPart part) {
        return this.recipe.indexOf(part);
    }

    public Spell add(AbstractSpellPart spellPart) {
        return new Spell(this.name, this.color, this.sound, (List<AbstractSpellPart>)Util.copyAndAdd(this.recipe, (Object)spellPart), this.particleTimeline);
    }

    public Spell add(AbstractSpellPart ... spellParts) {
        Spell spell = this;
        for (AbstractSpellPart part : spellParts) {
            spell = spell.add(part);
        }
        return spell;
    }

    public Spell add(AbstractSpellPart spellPart, int count) {
        Spell spell = this;
        for (int i = 0; i < count; ++i) {
            spell = spell.add(spellPart);
        }
        return spell;
    }

    public Spell setRecipe(@NotNull List<AbstractSpellPart> recipe) {
        return new Spell(this.name, this.color, this.sound, (List<AbstractSpellPart>)ImmutableList.copyOf(recipe), this.particleTimeline);
    }

    public Spell withColor(@NotNull ParticleColor color) {
        return new Spell(this.name, color, this.sound, this.recipe, this.particleTimeline);
    }

    public Spell withSound(@NotNull ConfiguredSpellSound sound) {
        return new Spell(this.name, this.color, sound, this.recipe, this.particleTimeline);
    }

    public Spell withTimeline(@NotNull TimelineMap timeline) {
        return new Spell(this.name, this.color, this.sound, this.recipe, timeline);
    }

    public Spell withName(String name) {
        return new Spell(name, this.color, this.sound, this.recipe, this.particleTimeline);
    }

    @Deprecated(forRemoval=true)
    public ParticleColor color() {
        return this.color;
    }

    public String name() {
        return this.name;
    }

    public TimelineMap particleTimeline() {
        return this.particleTimeline;
    }

    @Nullable
    public AbstractCastMethod getCastMethod() {
        if (this.recipe == null || this.recipe.isEmpty()) {
            return null;
        }
        return this.recipe.getFirst() instanceof AbstractCastMethod ? (AbstractCastMethod)this.recipe.getFirst() : null;
    }

    public List<AbstractAugment> getAugments(int startPosition, @Nullable LivingEntity caster) {
        AbstractSpellPart nextGlyph;
        ArrayList<AbstractAugment> augments = new ArrayList<AbstractAugment>();
        if (this.recipe == null || this.recipe.isEmpty()) {
            return augments;
        }
        for (int j = startPosition + 1; j < this.recipe.size() && (nextGlyph = this.recipe.get(j)) instanceof AbstractAugment; ++j) {
            AbstractAugment augment = (AbstractAugment)nextGlyph;
            augments.add(augment);
        }
        return augments;
    }

    public int getInstanceCount(AbstractSpellPart spellPart) {
        int count = 0;
        for (AbstractSpellPart abstractSpellPart : this.recipe) {
            if (!abstractSpellPart.equals(spellPart)) continue;
            ++count;
        }
        return count;
    }

    public int getBuffsAtIndex(int startPosition, @Nullable LivingEntity caster, AbstractAugment augment) {
        return (int)this.getAugments(startPosition, caster).stream().filter(a -> a.equals(augment)).count();
    }

    public int getCost() {
        int cost = 0;
        AbstractSpellPart augmentedPart = null;
        for (AbstractSpellPart part : this.recipe) {
            if (part == null) continue;
            if (!(part instanceof AbstractAugment)) {
                augmentedPart = part;
            }
            if (augmentedPart != null && part instanceof AbstractAugment) {
                AbstractAugment augment = (AbstractAugment)part;
                cost += augment.getCostForPart(augmentedPart);
                continue;
            }
            cost += part.getCastingCost();
        }
        return cost;
    }

    public boolean isEmpty() {
        return this.recipe == null || this.recipe.isEmpty();
    }

    public String getDisplayString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.recipe.size(); ++i) {
            AbstractSpellPart spellPart = this.recipe.get(i);
            int num = 1;
            for (int j = i + 1; j < this.recipe.size() && spellPart.name.equals(this.recipe.get((int)j).name); ++j) {
                ++num;
            }
            if (num > 1) {
                str.append(spellPart.getLocaleName()).append(" x").append(num);
                i += num - 1;
            } else {
                str.append(spellPart.getLocaleName());
            }
            if (i >= this.recipe.size() - 1) continue;
            str.append(" -> ");
        }
        return str.toString();
    }

    public boolean isValid() {
        return !this.isEmpty();
    }

    public List<ResourceLocation> serializeRecipe() {
        return this.recipe.stream().map(AbstractSpellPart::getRegistryName).toList();
    }

    public Mutable mutable() {
        return new Mutable(new ArrayList<AbstractSpellPart>(this.recipe), this.name, this.color, this.sound, this.particleTimeline);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spell spell = (Spell)o;
        return Objects.equals(this.recipe, spell.recipe) && Objects.equals(this.name, spell.name) && Objects.equals(this.color, spell.color) && Objects.equals(this.sound, spell.sound) && Objects.equals(this.particleTimeline, spell.particleTimeline);
    }

    public int hashCode() {
        return Objects.hash(this.recipe, this.name, this.color, this.sound, this.particleTimeline);
    }

    public static class Mutable {
        public List<AbstractSpellPart> recipe;
        public String name;
        public ParticleColor color;
        public ConfiguredSpellSound sound;
        public TimelineMap particleTimeline;

        public Mutable(List<AbstractSpellPart> recipe, String name, ParticleColor color, ConfiguredSpellSound spellSound, TimelineMap timeline) {
            this.recipe = recipe;
            this.name = name;
            this.color = color;
            this.sound = spellSound;
            this.particleTimeline = timeline;
        }

        public Mutable(List<AbstractSpellPart> recipe, String name, ParticleColor color, ConfiguredSpellSound spellSound) {
            this(recipe, name, color, spellSound, new TimelineMap());
        }

        public Mutable add(AbstractSpellPart spellPart) {
            this.recipe.add(spellPart);
            return this;
        }

        public Mutable add(AbstractSpellPart ... spellParts) {
            this.recipe.addAll(Arrays.asList(spellParts));
            return this;
        }

        public Mutable add(int index, AbstractSpellPart spellPart) {
            this.recipe.add(index, spellPart);
            return this;
        }

        public Mutable setRecipe(@NotNull List<AbstractSpellPart> recipe) {
            this.recipe = recipe;
            return this;
        }

        public Spell immutable() {
            return new Spell(this.name, this.color, this.sound, this.recipe, this.particleTimeline);
        }
    }
}

