/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.timelines;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.BurstMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.TrailMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.MotionProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.BaseTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.ProjectileTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineOption;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class OrbitTimeline
extends BaseTimeline<OrbitTimeline> {
    public static final MapCodec<OrbitTimeline> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TimelineEntryData.CODEC.fieldOf("trailEffect").forGetter(i -> i.trailEffect), (App)TimelineEntryData.CODEC.fieldOf("onResolvingEffect").forGetter(i -> i.onResolvingEffect), (App)TimelineEntryData.CODEC.fieldOf("onSpawnEffect").forGetter(i -> i.onSpawnEffect), (App)TimelineEntryData.CODEC.fieldOf("flairEffect").forGetter(i -> i.flairEffect), (App)SoundProperty.CODEC.fieldOf("castSound").forGetter(i -> i.spawnSound), (App)SoundProperty.CODEC.fieldOf("resolveSound").forGetter(i -> i.resolveSound)).apply((Applicative)instance, OrbitTimeline::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, OrbitTimeline> STREAM_CODEC = StreamCodec.composite(TimelineEntryData.STREAM, OrbitTimeline::trailEffect, TimelineEntryData.STREAM, OrbitTimeline::onResolvingEffect, TimelineEntryData.STREAM, OrbitTimeline::onSpawnEffect, TimelineEntryData.STREAM, OrbitTimeline::flairEffect, SoundProperty.STREAM_CODEC, i -> i.spawnSound, SoundProperty.STREAM_CODEC, i -> i.resolveSound, OrbitTimeline::new);
    public static final List<IParticleMotionType<?>> TRAIL_OPTIONS = new CopyOnWriteArrayList();
    public static final List<IParticleMotionType<?>> RESOLVING_OPTIONS = new CopyOnWriteArrayList();
    public TimelineEntryData trailEffect;
    public TimelineEntryData onResolvingEffect;
    public TimelineEntryData onSpawnEffect;
    public TimelineEntryData flairEffect;
    public SoundProperty resolveSound = new SoundProperty();
    public SoundProperty spawnSound = new SoundProperty();

    public OrbitTimeline() {
        this(new TimelineEntryData((ParticleMotion)new TrailMotion(), new PropertyParticleOptions()), new TimelineEntryData((ParticleMotion)new BurstMotion(), new PropertyParticleOptions()), new TimelineEntryData(), new TimelineEntryData(), new SoundProperty(), new SoundProperty());
    }

    public OrbitTimeline(TimelineEntryData trailEffect, TimelineEntryData onResolvingEffect, TimelineEntryData onSpawnEffect, TimelineEntryData flairEffect, SoundProperty spawnSound, SoundProperty resolveSound) {
        this.trailEffect = trailEffect;
        this.onResolvingEffect = onResolvingEffect;
        this.onSpawnEffect = onSpawnEffect;
        this.flairEffect = flairEffect;
        this.spawnSound = spawnSound;
        this.resolveSound = resolveSound;
    }

    public TimelineEntryData trailEffect() {
        return this.trailEffect;
    }

    public TimelineEntryData onResolvingEffect() {
        return this.onResolvingEffect;
    }

    public TimelineEntryData onSpawnEffect() {
        return this.onSpawnEffect;
    }

    public TimelineEntryData flairEffect() {
        return this.flairEffect;
    }

    @Override
    public IParticleTimelineType<OrbitTimeline> getType() {
        return (IParticleTimelineType)ParticleTimelineRegistry.ORBIT_TIMELINE.get();
    }

    @Override
    public List<BaseProperty<?>> getProperties() {
        return List.of(new MotionProperty(new TimelineOption(TimelineOption.TRAIL, this.trailEffect, ImmutableList.copyOf(TRAIL_OPTIONS))), new MotionProperty(new TimelineOption(TimelineOption.IMPACT, this.onResolvingEffect, ImmutableList.copyOf(RESOLVING_OPTIONS)), List.of(this.resolveSound)), new MotionProperty(new TimelineOption(TimelineOption.SPAWN, this.onSpawnEffect, ImmutableList.copyOf(ProjectileTimeline.SPAWN_OPTIONS)), List.of(this.spawnSound)), new MotionProperty(new TimelineOption(TimelineOption.FLAIR, this.flairEffect, ImmutableList.copyOf(ProjectileTimeline.FLAIR_OPTIONS))));
    }
}

