/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.timelines;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.particle.configurations.BurstMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.LightBlobMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.MotionProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.BaseTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineOption;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class DelayTimeline
extends BaseTimeline<DelayTimeline> {
    public static final MapCodec<DelayTimeline> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TimelineEntryData.CODEC.fieldOf("onTickEffect").forGetter(i -> i.onTickEffect), (App)TimelineEntryData.CODEC.fieldOf("resolvingEffect").forGetter(i -> i.onResolvingEffect), (App)SoundProperty.CODEC.fieldOf("resolvingSound").forGetter(i -> i.resolvingSound)).apply((Applicative)instance, DelayTimeline::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DelayTimeline> STREAM_CODEC = StreamCodec.composite(TimelineEntryData.STREAM, DelayTimeline::tickingEffect, TimelineEntryData.STREAM, DelayTimeline::onResolvingEffect, SoundProperty.STREAM_CODEC, DelayTimeline::resolvingSound, DelayTimeline::new);
    public static final List<IParticleMotionType<?>> TICKING_OPTIONS = new CopyOnWriteArrayList();
    public static final List<IParticleMotionType<?>> RESOLVING_OPTIONS = new CopyOnWriteArrayList();
    public TimelineEntryData onTickEffect;
    public TimelineEntryData onResolvingEffect;
    public SoundProperty resolvingSound;

    public DelayTimeline() {
        this(new TimelineEntryData(new LightBlobMotion()), new TimelineEntryData(new BurstMotion()), new SoundProperty());
    }

    public DelayTimeline(TimelineEntryData onTickEffect, TimelineEntryData onResolvingEffect, SoundProperty resolvingSound) {
        this.onTickEffect = onTickEffect;
        this.onResolvingEffect = onResolvingEffect;
        this.resolvingSound = resolvingSound;
    }

    public TimelineEntryData tickingEffect() {
        return this.onTickEffect;
    }

    public TimelineEntryData onResolvingEffect() {
        return this.onResolvingEffect;
    }

    public SoundProperty resolvingSound() {
        return this.resolvingSound;
    }

    @Override
    public IParticleTimelineType<DelayTimeline> getType() {
        return (IParticleTimelineType)ParticleTimelineRegistry.DELAY_TIMELINE.get();
    }

    @Override
    public List<BaseProperty<?>> getProperties() {
        return List.of(new MotionProperty(new TimelineOption(TimelineOption.TICK, this.onTickEffect, ImmutableList.copyOf(TICKING_OPTIONS))), new MotionProperty(new TimelineOption(TimelineOption.IMPACT, this.onResolvingEffect, ImmutableList.copyOf(RESOLVING_OPTIONS)), List.of(this.resolvingSound)));
    }
}

