/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.inventory;

import com.flanks255.pocketstorage.inventory.PSUItemHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PSUSlot {
    public static final PSUSlot EMPTY = new PSUSlot();
    private Item item;
    private int count;

    public PSUSlot() {
        this.count = 0;
        this.item = Items.AIR;
    }

    public PSUSlot(ResourceLocation itemIn, int countIn) {
        this.count = countIn;
        this.item = (Item)BuiltInRegistries.ITEM.get(itemIn);
    }

    public PSUSlot(ItemStack stack) {
        this.item = stack.getItem();
        this.count = stack.getCount();
    }

    public boolean checkItem(ItemStack stack) {
        return stack.is(this.item) && PSUItemHandler.isStandardItem(stack);
    }

    public PSUSlot(CompoundTag tag) {
        this.readNBT(tag);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void decrementCount(int dec) {
        this.count -= dec;
    }

    public void incrementCount(int inc, int cap) {
        this.count = Math.min(this.count + inc, cap);
    }

    public int incrementCount(int inc) {
        this.count += inc;
        return this.count;
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.item);
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("Item", BuiltInRegistries.ITEM.getKey((Object)this.item).toString());
        tag.putInt("Count", this.count);
        return tag;
    }

    public void readNBT(CompoundTag tag) {
        if (!tag.contains("Item")) {
            return;
        }
        this.item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)tag.getString("Item"))).orElse(Items.AIR);
        this.count = tag.contains("Count") && this.item != Items.AIR ? tag.getInt("Count") : 0;
    }
}

