/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.FireTypes;
import com.mgen256.al.ModBlockList;
import com.mgen256.al.ModSoundList;
import com.mgen256.al.PedestalTypes;
import com.mgen256.al.blocks.FireBase;
import com.mgen256.al.blocks.FirePitBase;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.ModBlock;
import com.mgen256.al.items.SoulWand;
import com.mgen256.al.items.Wand;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class Pedestal
extends ModBlock
implements SimpleWaterloggedBlock,
IHasFire {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty ACCEPT_POWER = BooleanProperty.create((String)"accept_power");
    public static final BooleanProperty ISPOWERED = BooleanProperty.create((String)"ispowered");
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");
    private static Component txt_shift;
    private static Component txt_tips;
    private static Component txt_rightclick;
    private static Component txt_sneaking;
    private static Component txt_signals;
    protected SIZE size;
    private static SoundEvent ignitionSound;

    protected Pedestal(Block mainblock, VoxelShape shape, SIZE size) {
        super(mainblock, mainblock.properties(), shape);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).setValue((Property)PREVIOUS_FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).setValue((Property)ACCEPT_POWER, (Comparable)Boolean.valueOf(true))).setValue((Property)ISPOWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        this.size = size;
        if (ignitionSound == null) {
            ignitionSound = size == SIZE.L ? AdditionalLights.getSound(ModSoundList.Fire_Ignition_L) : AdditionalLights.getSound(ModSoundList.Fire_Ignition_S);
        }
    }

    protected abstract ModBlockList getFireKey(BlockState var1);

    public abstract PedestalTypes getType();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        builder.add(new Property[]{FIRE_TYPE});
        builder.add(new Property[]{PREVIOUS_FIRE_TYPE});
        builder.add(new Property[]{ACCEPT_POWER});
        builder.add(new Property[]{ISPOWERED});
        builder.add(new Property[]{ACTIVATED});
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockgetter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public FluidState getFluidState(BlockState state) {
        return state.getValue((Property)BlockStateProperties.WATERLOGGED) == Boolean.TRUE ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private Block getFireBlock(BlockState state) {
        return AdditionalLights.getBlock(this.getFireKey(state));
    }

    public boolean setFire(Level level, BlockPos pos, BlockState state, boolean replaceOnly) {
        BlockPos upperpos = pos.above();
        BlockState upperBlockState = level.getBlockState(upperpos);
        Block upperblock = upperBlockState.getBlock();
        FireBase firebase = null;
        if (upperblock instanceof FireBase) {
            firebase = (FireBase)upperblock;
        }
        if (replaceOnly ? firebase == null : !(upperBlockState.isAir() || upperBlockState.getBlock() == Blocks.WATER || firebase != null)) {
            return false;
        }
        if (firebase != null && !((Boolean)level.getBlockState(upperpos).getValue((Property)FireBase.SUMMONED)).booleanValue()) {
            level.destroyBlock(upperpos, true);
        }
        return level.setBlockAndUpdate(upperpos, (BlockState)((BlockState)this.getFireBlock(state).defaultBlockState().setValue((Property)FireBase.SET, (Comparable)Boolean.valueOf(true))).setValue((Property)FireBase.SUMMONED, (Comparable)Boolean.valueOf(true)));
    }

    public void removeFire(Level level, BlockPos pos, BlockState state) {
        if (!(level.getBlockState(pos.above()).getBlock() instanceof FireBase)) {
            return;
        }
        level.setBlockAndUpdate(pos.above(), Blocks.AIR.defaultBlockState());
    }

    protected ItemInteractionResult useItemOn(ItemStack p_330929_, BlockState p_335716_, Level p_336112_, BlockPos p_328869_, Player p_332840_, InteractionHand p_336117_, BlockHitResult p_332723_) {
        if (p_330929_.getItem() instanceof Wand) {
            return ItemInteractionResult.FAIL;
        }
        if (!this.setFire(p_336112_, p_328869_, p_335716_, false)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Pedestal.playIgnitionSound(p_336112_, p_332840_, p_335716_.getBlock(), p_328869_);
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static void playIgnitionSound(Level level, Player player, Block block, BlockPos pos) {
        float volume = block instanceof FirePitBase ? 2.0f : 1.5f;
        level.playSound(player, pos, ignitionSound, SoundSource.BLOCKS, volume, 1.0f);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer == null) {
            return;
        }
        if (placer.getOffhandItem().getItem() instanceof SoulWand) {
            state = (BlockState)state.setValue((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.SOUL));
        }
        if (placer.isSuppressingSlidingDownLadder()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACCEPT_POWER, (Comparable)Boolean.valueOf(false)));
        } else {
            level.setBlockAndUpdate(pos, state);
            this.setFire(level, pos, state, false);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        state = level.getBlockState(pos);
        if (state.getValue((Property)ACCEPT_POWER) != Boolean.TRUE) {
            return;
        }
        if (level.hasNeighborSignal(pos)) {
            if (state.getValue((Property)ACTIVATED) == Boolean.TRUE) {
                return;
            }
            if (this.setFire(level, pos, state, false)) {
                Pedestal.playIgnitionSound(level, null, state.getBlock(), pos);
            }
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)ISPOWERED, (Comparable)Boolean.valueOf(true))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.getValue((Property)ISPOWERED)).booleanValue() && ((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            this.removeFire(level, pos, state);
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)ISPOWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (txt_shift == null) {
            if (I18n.exists((String)"additional_lights.txt.shift") != Boolean.TRUE) {
                return;
            }
            txt_shift = Component.translatable((String)"additional_lights.txt.shift");
            txt_tips = Component.translatable((String)"additional_lights.txt.tips");
            txt_rightclick = Component.translatable((String)"additional_lights.txt.block.pedestal.rightclick");
            txt_sneaking = Component.translatable((String)"additional_lights.txt.block.pedestal.sneaking");
            txt_signals = Component.translatable((String)"additional_lights.txt.block.pedestal.signals");
        }
        if (Screen.hasShiftDown()) {
            tooltip.add(txt_tips);
            tooltip.add(txt_rightclick);
            tooltip.add(txt_sneaking);
            tooltip.add(txt_signals);
        } else {
            tooltip.add(txt_shift);
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    static enum SIZE {
        S,
        L;

    }
}

