/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigManager {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_EXPULSION = "expulsion_pylon";
    public static final String CATEGORY_INFUSION = "infusion_pylon";
    public static final String CATEGORY_HARVESTER = "harvester_pylon";
    public static final ServerConfig SERVER;
    public static final ModConfigSpec SERVER_SPEC;

    private ConfigManager() {
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ModConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public final ModConfigSpec.BooleanValue teamSupportEnabled;
        public final ModConfigSpec.ConfigValue<List<? extends String>> expulsionAllowedDimensions;
        public final ModConfigSpec.IntValue expulsionWorldSpawnRadius;
        public final ModConfigSpec.BooleanValue expulsionPylonCanExplode;
        public final ModConfigSpec.IntValue expulsionPylonMaxRadius;
        public final ModConfigSpec.IntValue infusionMinimumDuration;
        public final ModConfigSpec.IntValue infusionRequiredDuration;
        public final ModConfigSpec.IntValue infusionAppliedDuration;
        public final ModConfigSpec.BooleanValue infusionChunkloads;
        public final ModConfigSpec.ConfigValue<List<? extends String>> infusionAllowedEffects;
        public final ModConfigSpec.ConfigValue<List<? extends String>> infusionDeniedEffects;
        public final ModConfigSpec.IntValue infusionMaximumPotency;
        public final ModConfigSpec.IntValue harvesterWorkDelay;
        public final ModConfigSpec.BooleanValue harvesterRequiresTool;
        public final ModConfigSpec.BooleanValue harvesterCanBeAutomated;
        public final ModConfigSpec.BooleanValue harvesterRequiresPower;
        public final ModConfigSpec.IntValue harvesterPowerCost;
        public final ModConfigSpec.IntValue harvesterPowerBuffer;

        ServerConfig(ModConfigSpec.Builder builder) {
            builder.push(ConfigManager.CATEGORY_GENERAL);
            this.teamSupportEnabled = builder.comment("Whether team support is enabled if a compatible mod (FTB Teams, Argonauts) is installed").define("teamSupportEnabled", true);
            builder.pop();
            builder.push(ConfigManager.CATEGORY_EXPULSION);
            this.expulsionAllowedDimensions = builder.comment("Which dimensions the Expulsion Pylon is allowed to operate in.").defineListAllowEmpty(List.of("expulsionAllowedDimensions"), () -> List.of("minecraft:overworld"), () -> "minecraft:overworld", s -> {
                String string;
                return s instanceof String && (string = (String)s).matches("^\\w+:\\w+$");
            });
            this.expulsionWorldSpawnRadius = builder.comment(new String[]{"The radius around the world spawn where the pylon is not allowed to operate.", "By default this uses the world spawn radius (/gamerule spawnRadius).", "This config will only take effect if it is larger than the world spawn radius."}).defineInRange("expulsionWorldSpawnRadius", 1, 1, 512);
            this.expulsionPylonCanExplode = builder.comment("Whether the Expulsion Pylon can be destroyed with explosions.").define("expulsionPylonCanExplode", false);
            this.expulsionPylonMaxRadius = builder.comment(new String[]{"Limit the max radius for expulsion pylons.", "Does not include center chunk, so a radius of 2 equals a 5x5 chunk diameter."}).defineInRange("expulsionPylonMaxRadius", 2, 0, 2);
            builder.pop();
            builder.push(ConfigManager.CATEGORY_INFUSION);
            this.infusionMinimumDuration = builder.comment(new String[]{"The minimum effect duration (in seconds) that can be used for Potion Filters.", "This defaults to 60 seconds to prevent unintended interactions", "with other mods that add persistent potion effects at low durations."}).defineInRange("infusionMinimumDuration", 60, 1, 3600);
            this.infusionRequiredDuration = builder.comment(new String[]{"The total duration (in seconds) required before a Potion Filter can be used.", "By default this is 3600 seconds/1 hour, which is equivalent to 7.5 vanilla extended potions."}).defineInRange("infusionRequiredDuration", 3600, 1, 28800);
            this.infusionAppliedDuration = builder.comment(new String[]{"The max duration of effects (in seconds) applied to the player.", "The duration is refreshed up to this amount every 60 ticks."}).defineInRange("infusionAppliedDuration", 20, 5, 60);
            this.infusionChunkloads = builder.comment(new String[]{"Whether the Infusion Pylon chunkloads itself.", "This is limited to one pylon per player, while the player is online."}).define("infusionChunkloads", true);
            this.infusionAllowedEffects = builder.comment(new String[]{"Effects that may be used in the Infusion Pylon.", "List may include either effect IDs (like `minecraft:strength`) or an entire namespace (like `minecraft`).", "If the list is empty, then all effects will be allowed except for those specifically denied."}).defineListAllowEmpty(List.of("infusionAllowedEffects"), ArrayList::new, () -> "minecraft:strength", s -> {
                String string;
                return s instanceof String && (string = (String)s).matches("^\\w+(:\\w+)?$");
            });
            this.infusionDeniedEffects = builder.comment(new String[]{"Effects that may not be used in the Infusion Pylon.", "This list will override the allowed effect list."}).defineListAllowEmpty(List.of("infusionDeniedEffects"), List.of("minecraft:absorption", "tombstone:ghostly_shape"), () -> "minecraft:strength", s -> {
                String string;
                return s instanceof String && (string = (String)s).matches("^\\w+(:\\w+)?$");
            });
            this.infusionMaximumPotency = builder.comment(new String[]{"The maximum potency that can be applied in the Infusion Pylon.", "This value is 0-indexed, so a Resistance V potion would be potency 4."}).defineInRange("infusionMaximumPotency", 3, 0, 255);
            builder.pop();
            builder.push(ConfigManager.CATEGORY_HARVESTER);
            this.harvesterWorkDelay = builder.comment("Delay between harvest attempts (in ticks).").defineInRange("harvesterWorkDelay", 60, 10, 120);
            this.harvesterRequiresTool = builder.comment(new String[]{"Whether the harvester requires a hoe to work.", "If enabled, it will use 1 durability per harvest action"}).define("harvesterRequiresTool", true);
            this.harvesterCanBeAutomated = builder.comment(new String[]{"Whether the harvester can have tools piped in to automate it.", "By default, unbreakable tools are required for full automation."}).define("harvesterCanBeAutomated", false);
            this.harvesterRequiresPower = builder.comment(new String[]{"Whether the harvester requires power to work.", "If enabled, it will disable the tool requirement and instead have an RF cost per block."}).define("harvesterRequiresPower", false);
            this.harvesterPowerCost = builder.comment("The RF cost per block harvested, if power usage is enabled.").defineInRange("harvesterPowerCost", 5, 1, 10000);
            this.harvesterPowerBuffer = builder.comment("Buffer size should be greater than power cost per block * 80.").defineInRange("harvesterPowerBuffer", 1000, 100, 1000000);
            builder.pop();
        }
    }
}

