/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class TowerRoofStairsOverhangComponent
extends TowerRoofComponent {
    public TowerRoofStairsOverhangComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFLTRStO.get(), nbt);
    }

    public TowerRoofStairsOverhangComponent(int i, TowerWingComponent wing, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFLTRStO.get(), i, x, y, z);
        this.setOrientation(Direction.SOUTH);
        this.size = wing.size + 2;
        this.height = this.size / 2;
        this.boundingBox = new BoundingBox(wing.getBoundingBox().minX() - 1, wing.getBoundingBox().maxY(), wing.getBoundingBox().minZ() - 1, wing.getBoundingBox().maxX() + 1, wing.getBoundingBox().maxY() + this.height - 1, wing.getBoundingBox().maxZ() + 1);
    }

    @Override
    public void postProcess(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState woodenSlab = Blocks.BIRCH_SLAB.defaultBlockState();
        BlockState woodenPlanks = Blocks.BIRCH_PLANKS.defaultBlockState();
        BlockState birchStairsNorth = (BlockState)Blocks.BIRCH_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)Direction.NORTH);
        BlockState birchStairsSouth = (BlockState)Blocks.BIRCH_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)Direction.SOUTH);
        BlockState birchStairsEast = (BlockState)Blocks.BIRCH_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)Direction.EAST);
        BlockState birchStairsWest = (BlockState)Blocks.BIRCH_STAIRS.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)Direction.WEST);
        for (int y = 0; y <= this.height; ++y) {
            int min = y;
            int max = this.size - y - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == min) {
                        if (z == min || z == max) {
                            this.placeBlock(world, woodenSlab, x, y, z, sbb);
                            continue;
                        }
                        this.placeBlock(world, birchStairsWest, x, y, z, sbb);
                        continue;
                    }
                    if (x == max) {
                        if (z == min || z == max) {
                            this.placeBlock(world, woodenSlab, x, y, z, sbb);
                            continue;
                        }
                        this.placeBlock(world, birchStairsEast, x, y, z, sbb);
                        continue;
                    }
                    if (z == max) {
                        this.placeBlock(world, birchStairsSouth, x, y, z, sbb);
                        continue;
                    }
                    if (z == min) {
                        this.placeBlock(world, birchStairsNorth, x, y, z, sbb);
                        continue;
                    }
                    this.placeBlock(world, woodenPlanks, x, y, z, sbb);
                }
            }
        }
    }
}

