/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastleDungeonRoom31Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleDungeonStepsComponent;

public class FinalCastleDungeonExitComponent
extends FinalCastleDungeonRoom31Component {
    public FinalCastleDungeonExitComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCDunEx.get(), nbt);
    }

    public FinalCastleDungeonExitComponent(int i, int x, int y, int z, Direction direction, int level) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCDunEx.get(), i, x, y, z, direction, level);
    }

    @Override
    public void addChildren(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        if (parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        Rotation bestDir = this.findStairDirectionTowards(parent.getBoundingBox().minX(), parent.getBoundingBox().minZ());
        FinalCastleDungeonStepsComponent steps0 = new FinalCastleDungeonStepsComponent(5, this.boundingBox.minZ() + 15, this.boundingBox.minY(), this.boundingBox.minZ() + 15, bestDir.rotate(Direction.SOUTH));
        list.addPiece((StructurePiece)steps0);
        steps0.addChildren(this, list, rand);
        if (this.level == 1) {
            steps0.buildLevelUnder(list, rand, this.level + 1);
        } else {
            steps0.buildBossRoomUnder(list, rand);
        }
    }

    @Override
    public void postProcess(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        super.postProcess(world, manager, generator, rand, sbb, chunkPosIn, blockPos);
        BlockState castleDoor = ((Block)TFBlocks.PINK_CASTLE_DOOR.get()).defaultBlockState();
        this.generateBox(world, sbb, 7, 0, 16, 7, 3, 18, castleDoor, AIR, false);
        this.generateBox(world, sbb, 7, 4, 16, 7, 4, 18, this.deco.blockState, this.deco.blockState, false);
    }

    public Rotation findStairDirectionTowards(int x, int z) {
        Vec3i center = BoundingBoxUtils.getCenter(this.boundingBox);
        int dx = center.getX() - x;
        int dz = center.getZ() - z;
        Rotation absoluteDir = Math.abs(dz) >= Math.abs(dx) ? (dz >= 0 ? Rotation.CLOCKWISE_180 : Rotation.NONE) : (dx >= 0 ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
        return absoluteDir;
    }

    @Override
    protected BlockState getForceFieldColor(RandomSource decoRNG) {
        return ((Block)TFBlocks.PINK_FORCE_FIELD.get()).defaultBlockState();
    }

    @Override
    protected BlockState getRuneColor(BlockState fieldColor) {
        return ((Block)TFBlocks.PINK_CASTLE_RUNE_BRICK.get()).defaultBlockState();
    }
}

