/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.Lazy;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBlocks;
import twilightforest.util.ColorUtil;
import twilightforest.world.components.structures.SpawnIndexProvider;
import twilightforest.world.components.structures.TFStructureDecorator;
import twilightforest.world.components.structures.util.ProgressionPiece;

@Deprecated
public abstract class TFStructureComponent
extends StructurePiece
implements SpawnIndexProvider,
ProgressionPiece {
    public TFStructureDecorator deco = null;
    protected int spawnListIndex = 0;
    private static final Lazy<Set<Block>> BLOCKS_NEEDING_POSTPROCESSING = Lazy.of(() -> ImmutableSet.builder().add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.TORCH).add((Object)Blocks.WALL_TORCH).add((Object)Blocks.OAK_FENCE).add((Object)Blocks.SPRUCE_FENCE).add((Object)Blocks.DARK_OAK_FENCE).add((Object)Blocks.ACACIA_FENCE).add((Object)Blocks.BIRCH_FENCE).add((Object)Blocks.JUNGLE_FENCE).add((Object)Blocks.LADDER).add((Object)Blocks.IRON_BARS).add((Object)Blocks.GLASS_PANE).add((Object)Blocks.OAK_STAIRS).add((Object)Blocks.SPRUCE_STAIRS).add((Object)Blocks.BIRCH_STAIRS).add((Object)Blocks.COBBLESTONE_WALL).add((Object)Blocks.RED_MUSHROOM_BLOCK).add((Object)Blocks.BROWN_MUSHROOM_BLOCK).add((Object)Blocks.REDSTONE_WIRE).add((Object)Blocks.TRIPWIRE).add((Object)Blocks.TRIPWIRE_HOOK).add((Object)Blocks.CHEST).add((Object)Blocks.TRAPPED_CHEST).add((Object)Blocks.STONE_BRICK_STAIRS).add((Object)Blocks.LAVA).add((Object)Blocks.WATER).add((Object)Blocks.QUARTZ_STAIRS).add((Object)((Block)TFBlocks.CASTLE_BRICK_STAIRS.get())).add((Object)((Block)TFBlocks.BLUE_FORCE_FIELD.get())).add((Object)((Block)TFBlocks.GREEN_FORCE_FIELD.get())).add((Object)((Block)TFBlocks.PINK_FORCE_FIELD.get())).add((Object)((Block)TFBlocks.VIOLET_FORCE_FIELD.get())).add((Object)((Block)TFBlocks.ORANGE_FORCE_FIELD.get())).add((Object)((Block)TFBlocks.BROWN_THORNS.get())).add((Object)((Block)TFBlocks.GREEN_THORNS.get())).add((Object)Blocks.GRAVEL).build());

    public TFStructureComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.spawnListIndex = nbt.getInt("si");
        this.deco = TFStructureDecorator.getDecoFor(nbt.getString("deco"));
        this.rotation = Rotation.NONE;
        this.rotation = Rotation.values()[nbt.getInt("rot") % Rotation.values().length];
    }

    public TFStructureComponent(StructurePieceType type, int i, BoundingBox boundingBox) {
        super(type, i, boundingBox);
        this.rotation = Rotation.NONE;
    }

    @Deprecated
    public TFStructureComponent(StructurePieceType type, int i, int x, int y, int z) {
        this(type, i, new BoundingBox(x, y, z, x, y, z));
    }

    protected static boolean shouldDebug() {
        return false;
    }

    protected void setDebugCorners(Level world) {
        if (this.rotation == null) {
            this.rotation = Rotation.NONE;
        }
        if (TFStructureComponent.shouldDebug()) {
            int i = this.rotation.ordinal() * 4;
            DyeColor[] colors = DyeColor.values();
            world.setBlockAndUpdate(new BlockPos(this.getBoundingBox().minX(), this.getBoundingBox().maxY() + i, this.getBoundingBox().minZ()), ColorUtil.WOOL.getColor(colors[i]));
            world.setBlockAndUpdate(new BlockPos(this.getBoundingBox().maxX(), this.getBoundingBox().maxY() + i + 1, this.getBoundingBox().minZ()), ColorUtil.WOOL.getColor(colors[1 + i]));
            world.setBlockAndUpdate(new BlockPos(this.getBoundingBox().minX(), this.getBoundingBox().maxY() + i + 2, this.getBoundingBox().maxZ()), ColorUtil.WOOL.getColor(colors[2 + i]));
            world.setBlockAndUpdate(new BlockPos(this.getBoundingBox().maxX(), this.getBoundingBox().maxY() + i + 3, this.getBoundingBox().maxZ()), ColorUtil.WOOL.getColor(colors[3 + i]));
        }
    }

    protected void setInvisibleTextEntity(WorldGenLevel world, int x, int y, int z, BoundingBox sbb, String s, boolean forcePlace, float additionalYOffset, Consumer<Vec3> positionAccumulator, Display.BillboardConstraints billboardConstraint) {
        BlockPos pos;
        if (forcePlace && sbb.isInside((Vec3i)(pos = new BlockPos(this.getWorldX(x, z), this.getWorldY(y), this.getWorldZ(x, z))))) {
            Display.TextDisplay display = new Display.TextDisplay(EntityType.TEXT_DISPLAY, (Level)world.getLevel());
            display.setText((Component)Component.literal((String)s));
            display.setBillboardConstraints(billboardConstraint);
            display.moveTo((double)pos.getX() + 0.5, (double)((float)pos.getY() + additionalYOffset), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            if (world.addFreshEntity((Entity)display)) {
                positionAccumulator.accept(display.position());
            }
        }
    }

    protected void placeBlock(WorldGenLevel worldIn, BlockState blockstateIn, int x, int y, int z, BoundingBox boundingboxIn) {
        BlockPos blockpos = new BlockPos(this.getWorldX(x, z), this.getWorldY(y), this.getWorldZ(x, z));
        if (blockstateIn == null) {
            TwilightForestMod.LOGGER.warn("TFStructureComponent: Block at Pos {} {} {} was null! Ignoring!", (Object)blockpos.getX(), (Object)blockpos.getY(), (Object)blockpos.getZ());
        }
        if (boundingboxIn.isInside((Vec3i)blockpos)) {
            if (this.mirror != Mirror.NONE) {
                blockstateIn = blockstateIn.mirror(this.mirror);
            }
            if (this.rotation != Rotation.NONE) {
                blockstateIn = blockstateIn.rotate(this.rotation);
            }
            worldIn.setBlock(blockpos, blockstateIn, 2);
            FluidState fluidstate = worldIn.getFluidState(blockpos);
            if (!fluidstate.isEmpty()) {
                worldIn.scheduleTick(blockpos, fluidstate.getType(), 0);
            }
            if (((Set)BLOCKS_NEEDING_POSTPROCESSING.get()).contains(blockstateIn.getBlock())) {
                worldIn.getChunk(blockpos).markPosForPostprocessing(blockpos);
            }
        }
    }

    protected void setDebugEntity(Level world, BlockPos blockpos, String s) {
        if (TFStructureComponent.shouldDebug()) {
            Sheep sheep = new Sheep(EntityType.SHEEP, world);
            sheep.setCustomName((Component)Component.literal((String)s));
            sheep.setNoAi(true);
            sheep.moveTo((double)blockpos.getX() + 0.5, (double)(blockpos.getY() + 10), (double)blockpos.getZ() + 0.5, 0.0f, 0.0f);
            sheep.setInvulnerable(true);
            sheep.setInvisible(true);
            sheep.setCustomNameVisible(true);
            sheep.setSilent(true);
            sheep.setNoGravity(true);
            world.addFreshEntity((Entity)sheep);
        }
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        tagCompound.putInt("si", this.spawnListIndex);
        tagCompound.putString("deco", TFStructureDecorator.getDecoString(this.deco));
        tagCompound.putInt("rot", this.rotation.ordinal());
    }

    @Override
    public int getSpawnIndex() {
        return this.spawnListIndex;
    }
}

