/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.UtilityPiece;
import twilightforest.world.components.structures.util.DecorationClearance;

public class AvoidLandmarkModifier
extends PlacementModifier {
    public static final MapCodec<AvoidLandmarkModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("occupies_surface").forGetter(o -> o.occupiesSurface), (App)Codec.BOOL.fieldOf("occupies_underground").forGetter(o -> o.occupiesUnderground), (App)Codec.BOOL.fieldOf("occupies_vegetation").forGetter(o -> o.occupiesVegetation), (App)Codec.INT.fieldOf("additional_clearance").forGetter(o -> o.additionalClearance), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).fieldOf("structures_allowed").forGetter(m -> m.structuresAllowed)).apply((Applicative)instance, AvoidLandmarkModifier::new)).validate(AvoidLandmarkModifier::validate);
    private final boolean occupiesSurface;
    private final boolean occupiesUnderground;
    private final boolean occupiesVegetation;
    private final int additionalClearance;
    private final HolderSet<Structure> structuresAllowed;

    public AvoidLandmarkModifier(boolean occupiesSurface, boolean occupiesUnderground, int additionalClearance, HolderSet<Structure> structuresAllowed) {
        this(occupiesSurface, occupiesUnderground, false, additionalClearance, structuresAllowed);
    }

    public AvoidLandmarkModifier(boolean occupiesSurface, boolean occupiesUnderground, boolean occupiesVegetation, int additionalClearance, HolderSet<Structure> structuresAllowed) {
        this.occupiesSurface = occupiesSurface;
        this.occupiesUnderground = occupiesUnderground;
        this.occupiesVegetation = occupiesVegetation;
        this.additionalClearance = additionalClearance;
        this.structuresAllowed = structuresAllowed;
    }

    public static AvoidLandmarkModifier checkSurface() {
        return AvoidLandmarkModifier.checkSurface((HolderSet<Structure>)HolderSet.empty());
    }

    public static AvoidLandmarkModifier checkSurface(HolderSet<Structure> structuresAllowed) {
        return new AvoidLandmarkModifier(true, false, 0, structuresAllowed);
    }

    public static AvoidLandmarkModifier checkUnderground() {
        return new AvoidLandmarkModifier(false, true, 0, (HolderSet<Structure>)HolderSet.empty());
    }

    public static AvoidLandmarkModifier checkBoth() {
        return new AvoidLandmarkModifier(true, true, 0, (HolderSet<Structure>)HolderSet.empty());
    }

    public static AvoidLandmarkModifier checkVegetation() {
        return new AvoidLandmarkModifier(false, false, true, 0, (HolderSet<Structure>)HolderSet.empty());
    }

    public Stream<BlockPos> getPositions(PlacementContext worldDecoratingHelper, RandomSource random, BlockPos blockPos) {
        ChunkAccess chunk = worldDecoratingHelper.getLevel().getChunk(blockPos);
        Set structuresOverlappingChunk = chunk.getAllReferences().entrySet();
        for (Map.Entry startsForStructure : structuresOverlappingChunk) {
            if (!this.structureTypeBlocksFeaturePlacement(worldDecoratingHelper, blockPos, (Structure)startsForStructure.getKey(), (LongSet)startsForStructure.getValue())) continue;
            return Stream.empty();
        }
        return Stream.of(blockPos);
    }

    private boolean structureTypeBlocksFeaturePlacement(PlacementContext worldDecoratingHelper, BlockPos blockPos, Structure structure, LongSet coordsForStarts) {
        DecorationClearance decorationClearance;
        if (this.allowedInsideStructure(structure) || !(structure instanceof DecorationClearance) || this.clearFromStructureZone(decorationClearance = (DecorationClearance)structure)) {
            return false;
        }
        LongIterator longIterator = coordsForStarts.iterator();
        while (longIterator.hasNext()) {
            BlockPos diff;
            StructureStart startForStructure;
            long packedChunkCoord = (Long)longIterator.next();
            int startChunkX = (int)packedChunkCoord;
            int startChunkZ = (int)(packedChunkCoord >> 32);
            ChunkAccess startChunk = worldDecoratingHelper.getLevel().getChunk(startChunkX, startChunkZ);
            if (startChunk == null || (startForStructure = startChunk.getStartForStructure(structure)) == null || !this.placementIsBlocked(blockPos, startForStructure, diff = blockPos.subtract((Vec3i)startForStructure.getBoundingBox().getCenter()), decorationClearance.chunkClearanceRadius())) continue;
            return true;
        }
        return false;
    }

    private boolean allowedInsideStructure(Structure overlappingStructure) {
        boolean configAllowedOverlap = false;
        for (Holder allowedStructure : this.structuresAllowed) {
            if (!allowedStructure.isBound() || !overlappingStructure.equals(allowedStructure.value())) continue;
            configAllowedOverlap = true;
        }
        return configAllowedOverlap;
    }

    private boolean clearFromStructureZone(DecorationClearance decorationClearance) {
        boolean surfaceClear = !this.occupiesSurface || decorationClearance.isSurfaceDecorationsAllowed();
        boolean undergroundClear = !this.occupiesUnderground || decorationClearance.isUndergroundDecoAllowed();
        boolean vegetationClear = !this.occupiesVegetation || decorationClearance.isGrassDecoAllowed();
        return surfaceClear && undergroundClear && vegetationClear;
    }

    private boolean placementIsBlocked(BlockPos blockPos, StructureStart startForStructure, BlockPos featureDistanceXZ, float chunkClearanceRadius) {
        if (chunkClearanceRadius <= 0.0f) {
            for (StructurePiece piece : startForStructure.getPieces()) {
                if (piece instanceof UtilityPiece) {
                    UtilityPiece utilityPiece = (UtilityPiece)piece;
                    if (utilityPiece.allowFeatures) continue;
                }
                if (BoundingBoxUtils.greatestAxalDistance(piece.getBoundingBox(), blockPos) > this.additionalClearance) continue;
                return true;
            }
            return false;
        }
        float size = chunkClearanceRadius * 16.0f + (float)this.additionalClearance;
        return (float)Math.abs(featureDistanceXZ.getX()) < size && (float)Math.abs(featureDistanceXZ.getZ()) < size;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TFFeatureModifiers.NO_STRUCTURE.get();
    }

    private static DataResult<AvoidLandmarkModifier> validate(AvoidLandmarkModifier config) {
        return config.occupiesSurface || config.occupiesUnderground || config.occupiesVegetation ? DataResult.success((Object)((Object)config)) : DataResult.error(() -> "Feature Decorator cannot have no occupancy");
    }
}

