/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import twilightforest.TwilightForestMod;
import twilightforest.world.TFTeleporter;

public class NoReturnTeleporter
extends TFTeleporter {
    public static DimensionTransition createNoPortalTransition(ServerLevel dest, Entity entity, BlockPos destPos) {
        DimensionTransition info = NoReturnTeleporter.moveToSafeCoords(dest, entity, destPos);
        info = NoReturnTeleporter.placePosition(entity, dest, info.pos());
        return info;
    }

    private static DimensionTransition placePosition(Entity entity, ServerLevel level, Vec3 pos) {
        NoReturnTeleporter.loadSurroundingArea(level, pos);
        BlockPos spot = NoReturnTeleporter.findPortalCoords(level, pos, blockPos -> NoReturnTeleporter.isPortalAt(level, blockPos));
        String name = entity.getName().getString();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found existing teleportation for {} at {}", (Object)name, (Object)spot);
            return NoReturnTeleporter.makePortalInfo(level, entity, Vec3.atCenterOf((Vec3i)spot.above()));
        }
        spot = NoReturnTeleporter.findPortalCoords(level, pos, blockpos -> NoReturnTeleporter.isIdealForPortal(level, blockpos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal teleportation spot for {} at {}", (Object)name, (Object)spot);
            return NoReturnTeleporter.makePortalInfo(level, entity, Vec3.atCenterOf((Vec3i)spot.above()));
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal teleportation spot, shooting for okay one for {}", (Object)name);
        spot = NoReturnTeleporter.findPortalCoords(level, pos, blockPos -> NoReturnTeleporter.isOkayForPortal(level, blockPos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay teleportation spot for {} at {}", (Object)name, (Object)spot);
            return NoReturnTeleporter.makePortalInfo(level, entity, Vec3.atCenterOf((Vec3i)spot.above()));
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay teleportation spot, just making a random one for {}", (Object)name);
        double yFactor = NoReturnTeleporter.getYFactor(level);
        return NoReturnTeleporter.makePortalInfo(level, entity, entity.getX() * NoReturnTeleporter.getHorizontalScale(level), entity.getY() * yFactor + 2.0, entity.getZ() * NoReturnTeleporter.getHorizontalScale(level));
    }
}

