/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.recipe;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import twilightforest.init.TFItems;
import twilightforest.init.TFRecipes;

public class MoonwormQueenRepairRecipe
extends CustomRecipe {
    public MoonwormQueenRepairRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack queen = null;
        ArrayList<ItemStack> berries = new ArrayList<ItemStack>();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stackInQuestion = input.getItem(i);
            if (stackInQuestion.isEmpty()) continue;
            if (stackInQuestion.is((Item)TFItems.MOONWORM_QUEEN.get()) && stackInQuestion.isDamaged()) {
                if (queen != null) {
                    return false;
                }
                queen = stackInQuestion;
                continue;
            }
            if (stackInQuestion.is((Item)TFItems.TORCHBERRIES.get())) {
                berries.add(stackInQuestion);
                continue;
            }
            return false;
        }
        return queen != null && !berries.isEmpty();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider access) {
        ArrayList<Item> berries = new ArrayList<Item>();
        ItemStack queen = null;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemstack = input.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (itemstack.is((Item)TFItems.MOONWORM_QUEEN.get())) {
                if (queen == null) {
                    queen = itemstack;
                } else {
                    return ItemStack.EMPTY;
                }
            }
            if (!itemstack.is((Item)TFItems.TORCHBERRIES.get())) continue;
            berries.add(itemstack.getItem());
        }
        if (!berries.isEmpty() && queen != null && queen.isDamaged()) {
            ItemStack newQueen = ((Item)TFItems.MOONWORM_QUEEN.get()).getDefaultInstance();
            newQueen.setDamageValue(queen.getDamageValue() - berries.size() * 64);
            return newQueen;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFRecipes.MOONWORM_QUEEN_REPAIR_RECIPE.get();
    }
}

