/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HollowLogItem
extends BlockItem {
    private final Block horizontalLog;
    private final Block verticalLog;
    private final Block climbable;

    public HollowLogItem(Holder<Block> horizontalLog, Holder<Block> verticalLog, Holder<Block> climbable, Item.Properties properties) {
        super((Block)verticalLog.value(), properties);
        this.horizontalLog = (Block)horizontalLog.value();
        this.verticalLog = (Block)verticalLog.value();
        this.climbable = (Block)climbable.value();
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        return switch (context.getClickedFace().getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y -> this.verticalLog.getStateForPlacement(context);
            case Direction.Axis.X, Direction.Axis.Z -> this.horizontalLog.getStateForPlacement(context);
        };
    }

    public void registerBlocks(Map<Block, Item> blockItemMap, Item item) {
        super.registerBlocks(blockItemMap, item);
        blockItemMap.put(this.horizontalLog, item);
        blockItemMap.put(this.verticalLog, item);
        blockItemMap.put(this.climbable, item);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockItemMap, Item item) {
        super.removeFromBlockToItemMap(blockItemMap, item);
        blockItemMap.remove(this.horizontalLog);
        blockItemMap.remove(this.verticalLog);
        blockItemMap.remove(this.climbable);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return 300;
    }
}

