/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import twilightforest.entity.CharmEffect;
import twilightforest.entity.MagicPainting;
import twilightforest.entity.ProtectionBox;
import twilightforest.entity.RovingCube;
import twilightforest.entity.SlideBlock;
import twilightforest.entity.TFEntityNames;
import twilightforest.entity.boss.AlphaYeti;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraMortar;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.boss.Minoshroom;
import twilightforest.entity.boss.Naga;
import twilightforest.entity.boss.PlateauBoss;
import twilightforest.entity.boss.SnowQueen;
import twilightforest.entity.boss.UrGhast;
import twilightforest.entity.monster.Adherent;
import twilightforest.entity.monster.ArmoredGiant;
import twilightforest.entity.monster.BlockChainGoblin;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.entity.monster.CarminiteGolem;
import twilightforest.entity.monster.DeathTome;
import twilightforest.entity.monster.FireBeetle;
import twilightforest.entity.monster.GiantMiner;
import twilightforest.entity.monster.HarbingerCube;
import twilightforest.entity.monster.HedgeSpider;
import twilightforest.entity.monster.HelmetCrab;
import twilightforest.entity.monster.HostileWolf;
import twilightforest.entity.monster.IceCrystal;
import twilightforest.entity.monster.KingSpider;
import twilightforest.entity.monster.Kobold;
import twilightforest.entity.monster.LichMinion;
import twilightforest.entity.monster.LowerGoblinKnight;
import twilightforest.entity.monster.LoyalZombie;
import twilightforest.entity.monster.MazeSlime;
import twilightforest.entity.monster.Minotaur;
import twilightforest.entity.monster.MistWolf;
import twilightforest.entity.monster.MosquitoSwarm;
import twilightforest.entity.monster.PinchBeetle;
import twilightforest.entity.monster.Redcap;
import twilightforest.entity.monster.RedcapSapper;
import twilightforest.entity.monster.RisingZombie;
import twilightforest.entity.monster.SkeletonDruid;
import twilightforest.entity.monster.SlimeBeetle;
import twilightforest.entity.monster.SnowGuardian;
import twilightforest.entity.monster.StableIceCore;
import twilightforest.entity.monster.SwarmSpider;
import twilightforest.entity.monster.TowerBroodling;
import twilightforest.entity.monster.TowerwoodBorer;
import twilightforest.entity.monster.Troll;
import twilightforest.entity.monster.UnstableIceCore;
import twilightforest.entity.monster.UpperGoblinKnight;
import twilightforest.entity.monster.WinterWolf;
import twilightforest.entity.monster.Wraith;
import twilightforest.entity.monster.Yeti;
import twilightforest.entity.passive.Bighorn;
import twilightforest.entity.passive.Boar;
import twilightforest.entity.passive.Deer;
import twilightforest.entity.passive.DwarfRabbit;
import twilightforest.entity.passive.Penguin;
import twilightforest.entity.passive.QuestRam;
import twilightforest.entity.passive.Raven;
import twilightforest.entity.passive.Squirrel;
import twilightforest.entity.passive.TinyBird;
import twilightforest.entity.projectile.ChainBlock;
import twilightforest.entity.projectile.CubeOfAnnihilation;
import twilightforest.entity.projectile.FallingIce;
import twilightforest.entity.projectile.IceArrow;
import twilightforest.entity.projectile.IceBomb;
import twilightforest.entity.projectile.IceSnowball;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.entity.projectile.MoonwormShot;
import twilightforest.entity.projectile.NatureBolt;
import twilightforest.entity.projectile.SeekerArrow;
import twilightforest.entity.projectile.SlimeProjectile;
import twilightforest.entity.projectile.ThrownBlock;
import twilightforest.entity.projectile.ThrownWep;
import twilightforest.entity.projectile.TomeBolt;
import twilightforest.entity.projectile.TwilightWandBolt;

@EventBusSubscriber(modid="twilightforest", bus=EventBusSubscriber.Bus.MOD)
public class TFEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"twilightforest");
    public static final DeferredRegister<Item> SPAWN_EGGS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"twilightforest");
    public static final DeferredHolder<EntityType<?>, EntityType<Adherent>> ADHERENT = TFEntities.make(TFEntityNames.ADHERENT, Adherent::new, MobCategory.MONSTER, 0.8f, 2.2f, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<AlphaYeti>> ALPHA_YETI = TFEntities.make(TFEntityNames.ALPHA_YETI, AlphaYeti::new, MobCategory.MONSTER, 3.8f, 5.0f, 0xCDCDCD, 2705518);
    public static final DeferredHolder<EntityType<?>, EntityType<ArmoredGiant>> ARMORED_GIANT = TFEntities.make(TFEntityNames.ARMORED_GIANT, ArmoredGiant::new, MobCategory.MONSTER, 2.4f, 7.2f, 2331537, 0x9A9A9A);
    public static final DeferredHolder<EntityType<?>, EntityType<Bighorn>> BIGHORN_SHEEP = TFEntities.make(TFEntityNames.BIGHORN_SHEEP, Bighorn::new, MobCategory.CREATURE, 0.9f, 1.3f, 14405295, 14141297);
    public static final DeferredHolder<EntityType<?>, EntityType<BlockChainGoblin>> BLOCKCHAIN_GOBLIN = TFEntities.make(TFEntityNames.BLOCKCHAIN_GOBLIN, BlockChainGoblin::new, MobCategory.MONSTER, 0.9f, 1.4f, 13887420, 0x1F3FFF);
    public static final DeferredHolder<EntityType<?>, EntityType<Boar>> BOAR = TFEntities.make(TFEntityNames.BOAR, Boar::new, MobCategory.CREATURE, 0.9f, 0.9f, 8611131, 16773066);
    public static final DeferredHolder<EntityType<?>, EntityType<TowerBroodling>> CARMINITE_BROODLING = TFEntities.make(TFEntityNames.CARMINITE_BROODLING, TowerBroodling::new, MobCategory.MONSTER, 0.7f, 0.5f, 3423252, 12250626);
    public static final DeferredHolder<EntityType<?>, EntityType<CarminiteGhastguard>> CARMINITE_GHASTGUARD = TFEntities.make(TFEntityNames.CARMINITE_GHASTGUARD, CarminiteGhastguard::new, MobCategory.MONSTER, 4.0f, 6.0f, true, 0xBCBCBC, 0xB77878);
    public static final DeferredHolder<EntityType<?>, EntityType<CarminiteGhastling>> CARMINITE_GHASTLING = TFEntities.make(TFEntityNames.CARMINITE_GHASTLING, CarminiteGhastling::new, MobCategory.MONSTER, 1.1f, 1.5f, 0.5f, true, 0xBCBCBC, 10961731);
    public static final DeferredHolder<EntityType<?>, EntityType<CarminiteGolem>> CARMINITE_GOLEM = TFEntities.make(TFEntityNames.CARMINITE_GOLEM, CarminiteGolem::new, MobCategory.MONSTER, 1.4f, 2.9f, 7028000, 14867930);
    public static final DeferredHolder<EntityType<?>, EntityType<ChainBlock>> CHAIN_BLOCK = TFEntities.buildNoEgg(TFEntityNames.CHAIN_BLOCK, TFEntities.makeCastedBuilder(ChainBlock.class, ChainBlock::new, 0.6f, 0.6f, 80, 1), true);
    public static final DeferredHolder<EntityType<?>, EntityType<CharmEffect>> CHARM_EFFECT = TFEntities.buildNoEgg(TFEntityNames.CHARM_EFFECT, TFEntities.makeCastedBuilder(CharmEffect.class, CharmEffect::new, 0.0f, 0.0f, 16, Integer.MAX_VALUE).noSave().noSummon(), true);
    public static final DeferredHolder<EntityType<?>, EntityType<CubeOfAnnihilation>> CUBE_OF_ANNIHILATION = TFEntities.buildNoEgg(TFEntityNames.CUBE_OF_ANNIHILATION, TFEntities.makeCastedBuilder(CubeOfAnnihilation.class, CubeOfAnnihilation::new, 1.0f, 1.0f, 80, 1), true);
    public static final DeferredHolder<EntityType<?>, EntityType<DeathTome>> DEATH_TOME = TFEntities.make(TFEntityNames.DEATH_TOME, DeathTome::new, MobCategory.MONSTER, 0.75f, 1.5f, 7818786, 14405054);
    public static final DeferredHolder<EntityType<?>, EntityType<Deer>> DEER = TFEntities.make(TFEntityNames.DEER, Deer::new, MobCategory.CREATURE, 0.7f, 1.8f, 8080686, 4924445);
    public static final DeferredHolder<EntityType<?>, EntityType<DwarfRabbit>> DWARF_RABBIT = TFEntities.make(TFEntityNames.DWARF_RABBIT, DwarfRabbit::new, MobCategory.CREATURE, 0.4f, 0.4f, 0xFEFEEE, 0xCCAA99);
    public static final DeferredHolder<EntityType<?>, EntityType<FallingIce>> FALLING_ICE = TFEntities.make(TFEntityNames.FALLING_ICE, FallingIce::new, MobCategory.MISC, 1.0f, 1.0f, true, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<FireBeetle>> FIRE_BEETLE = TFEntities.make(TFEntityNames.FIRE_BEETLE, FireBeetle::new, MobCategory.MONSTER, 1.1f, 0.5f, true, 1903360, 13332261);
    public static final DeferredHolder<EntityType<?>, EntityType<GiantMiner>> GIANT_MINER = TFEntities.make(TFEntityNames.GIANT_MINER, GiantMiner::new, MobCategory.MONSTER, 2.4f, 7.2f, 2169682, 0x9A9A9A);
    public static final DeferredHolder<EntityType<?>, EntityType<HarbingerCube>> HARBINGER_CUBE = TFEntities.make(TFEntityNames.HARBINGER_CUBE, HarbingerCube::new, MobCategory.MONSTER, 1.9f, 2.4f, true, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<HedgeSpider>> HEDGE_SPIDER = TFEntities.make(TFEntityNames.HEDGE_SPIDER, HedgeSpider::new, MobCategory.MONSTER, 1.4f, 0.9f, 2318099, 5645907);
    public static final DeferredHolder<EntityType<?>, EntityType<HelmetCrab>> HELMET_CRAB = TFEntities.make(TFEntityNames.HELMET_CRAB, HelmetCrab::new, MobCategory.MONSTER, 0.8f, 1.1f, 0.45f, false, 16486475, 13887420);
    public static final DeferredHolder<EntityType<?>, EntityType<HostileWolf>> HOSTILE_WOLF = TFEntities.make(TFEntityNames.HOSTILE_WOLF, HostileWolf::new, MobCategory.MONSTER, 0.6f, 0.85f, 0xD7D3D3, 11214356);
    public static final DeferredHolder<EntityType<?>, EntityType<Hydra>> HYDRA = TFEntities.make(TFEntityNames.HYDRA, Hydra::new, MobCategory.MONSTER, 16.0f, 12.0f, true, 1321280, 2719851);
    public static final DeferredHolder<EntityType<?>, EntityType<HydraMortar>> HYDRA_MORTAR = TFEntities.buildNoEgg(TFEntityNames.HYDRA_MORTAR, TFEntities.makeCastedBuilder(HydraMortar.class, HydraMortar::new, 0.75f, 0.75f, 150, 3), true);
    public static final DeferredHolder<EntityType<?>, EntityType<IceArrow>> ICE_ARROW = TFEntities.buildNoEgg(TFEntityNames.ICE_ARROW, TFEntities.makeCastedBuilder(IceArrow.class, IceArrow::new, 0.5f, 0.5f, 150, 1), false);
    public static final DeferredHolder<EntityType<?>, EntityType<IceBomb>> THROWN_ICE = TFEntities.buildNoEgg(TFEntityNames.THROWN_ICE, TFEntities.makeCastedBuilder(IceBomb.class, IceBomb::new, 1.0f, 1.0f, 80, 2), true);
    public static final DeferredHolder<EntityType<?>, EntityType<IceCrystal>> ICE_CRYSTAL = TFEntities.make(TFEntityNames.ICE_CRYSTAL, IceCrystal::new, MobCategory.MONSTER, 0.6f, 1.8f, 14477822, 11389691);
    public static final DeferredHolder<EntityType<?>, EntityType<IceSnowball>> ICE_SNOWBALL = TFEntities.buildNoEgg(TFEntityNames.ICE_SNOWBALL, TFEntities.makeCastedBuilder(IceSnowball.class, IceSnowball::new, 0.25f, 0.25f, 150, 3), false);
    public static final DeferredHolder<EntityType<?>, EntityType<KingSpider>> KING_SPIDER = TFEntities.make(TFEntityNames.KING_SPIDER, KingSpider::new, MobCategory.MONSTER, 1.6f, 1.6f, 2890254, 16760855);
    public static final DeferredHolder<EntityType<?>, EntityType<KnightPhantom>> KNIGHT_PHANTOM = TFEntities.make(TFEntityNames.KNIGHT_PHANTOM, KnightPhantom::new, MobCategory.MONSTER, 1.25f, 2.5f, 10905403, 13887420);
    public static final DeferredHolder<EntityType<?>, EntityType<Kobold>> KOBOLD = TFEntities.make(TFEntityNames.KOBOLD, Kobold::new, MobCategory.MONSTER, 0.8f, 1.1f, 3612822, 9002267);
    public static final DeferredHolder<EntityType<?>, EntityType<Lich>> LICH = TFEntities.make(TFEntityNames.LICH, Lich::new, MobCategory.MONSTER, 0.8f, 2.5f, 1.95f, false, 11314313, 3540082);
    public static final DeferredHolder<EntityType<?>, EntityType<LichBolt>> LICH_BOLT = TFEntities.buildNoEgg(TFEntityNames.LICH_BOLT, TFEntities.makeCastedBuilder(LichBolt.class, LichBolt::new, 0.25f, 0.25f, 150, 2), false);
    public static final DeferredHolder<EntityType<?>, EntityType<LichBomb>> LICH_BOMB = TFEntities.buildNoEgg(TFEntityNames.LICH_BOMB, TFEntities.makeCastedBuilder(LichBomb.class, LichBomb::new, 0.25f, 0.25f, 150, 3), false);
    public static final DeferredHolder<EntityType<?>, EntityType<LichMinion>> LICH_MINION = TFEntities.make(TFEntityNames.LICH_MINION, LichMinion::new, MobCategory.MONSTER, 0.6f, 1.95f, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<LowerGoblinKnight>> LOWER_GOBLIN_KNIGHT = TFEntities.make(TFEntityNames.LOWER_GOBLIN_KNIGHT, LowerGoblinKnight::new, MobCategory.MONSTER, 0.7f, 1.1f, 0x566055, 13887420);
    public static final DeferredHolder<EntityType<?>, EntityType<LoyalZombie>> LOYAL_ZOMBIE = TFEntities.make(TFEntityNames.LOYAL_ZOMBIE, LoyalZombie::new, MobCategory.MONSTER, 0.6f, 1.95f, 0, 0, -0.7f);
    public static final DeferredHolder<EntityType<?>, EntityType<MazeSlime>> MAZE_SLIME = TFEntities.make(TFEntityNames.MAZE_SLIME, MazeSlime::new, MobCategory.MONSTER, 0.52f, 0.52f, 0.325f, false, 0xA3A3A3, 2767639);
    public static final DeferredHolder<EntityType<?>, EntityType<Minoshroom>> MINOSHROOM = TFEntities.make(TFEntityNames.MINOSHROOM, Minoshroom::new, MobCategory.MONSTER, 1.49f, 2.5f, 11014162, 11173222);
    public static final DeferredHolder<EntityType<?>, EntityType<Minotaur>> MINOTAUR = TFEntities.make(TFEntityNames.MINOTAUR, Minotaur::new, MobCategory.MONSTER, 0.6f, 2.1f, 4141092, 11173222);
    public static final DeferredHolder<EntityType<?>, EntityType<MistWolf>> MIST_WOLF = TFEntities.make(TFEntityNames.MIST_WOLF, MistWolf::new, MobCategory.MONSTER, 1.4f, 1.9f, 1.45f, false, 3806225, 14862474);
    public static final DeferredHolder<EntityType<?>, EntityType<MoonwormShot>> MOONWORM_SHOT = TFEntities.buildNoEgg(TFEntityNames.MOONWORM_SHOT, TFEntities.makeCastedBuilder(MoonwormShot.class, MoonwormShot::new, 0.25f, 0.25f, 150, 3), false);
    public static final DeferredHolder<EntityType<?>, EntityType<MosquitoSwarm>> MOSQUITO_SWARM = TFEntities.make(TFEntityNames.MOSQUITO_SWARM, MosquitoSwarm::new, MobCategory.MONSTER, 0.7f, 1.9f, 526596, 2961185);
    public static final DeferredHolder<EntityType<?>, EntityType<Naga>> NAGA = TFEntities.make(TFEntityNames.NAGA, Naga::new, MobCategory.MONSTER, 2.0f, 3.0f, 2.0f, true, 10801942, 1783819);
    public static final DeferredHolder<EntityType<?>, EntityType<NatureBolt>> NATURE_BOLT = TFEntities.buildNoEgg(TFEntityNames.NATURE_BOLT, TFEntities.makeCastedBuilder(NatureBolt.class, NatureBolt::new, 0.25f, 0.25f, 150, 5), false);
    public static final DeferredHolder<EntityType<?>, EntityType<MagicPainting>> MAGIC_PAINTING = TFEntities.buildNoEgg(TFEntityNames.MAGIC_PAINTING, TFEntities.makeCastedBuilder(MagicPainting.class, MagicPainting::new, 0.5f, 0.5f, 10, Integer.MAX_VALUE), false);
    public static final DeferredHolder<EntityType<?>, EntityType<Penguin>> PENGUIN = TFEntities.make(TFEntityNames.PENGUIN, Penguin::new, MobCategory.CREATURE, 0.5f, 0.9f, 1185051, 16379346);
    public static final DeferredHolder<EntityType<?>, EntityType<PinchBeetle>> PINCH_BEETLE = TFEntities.make(TFEntityNames.PINCH_BEETLE, PinchBeetle::new, MobCategory.MONSTER, 1.2f, 0.5f, 12358439, 2364937);
    public static final DeferredHolder<EntityType<?>, EntityType<PlateauBoss>> PLATEAU_BOSS = TFEntities.make(TFEntityNames.PLATEAU_BOSS, PlateauBoss::new, MobCategory.MONSTER, 1.0f, 1.0f, true, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<ProtectionBox>> PROTECTION_BOX = TFEntities.buildNoEgg(TFEntityNames.PROTECTION_BOX, TFEntities.makeCastedBuilder(ProtectionBox.class, ProtectionBox::new, 0.0f, 0.0f, 80, 3).noSave().noSummon(), true);
    public static final DeferredHolder<EntityType<?>, EntityType<QuestRam>> QUEST_RAM = TFEntities.make(TFEntityNames.QUEST_RAM, QuestRam::new, MobCategory.CREATURE, 1.25f, 2.9f, 0xFEFEEE, 0x33AADD);
    public static final DeferredHolder<EntityType<?>, EntityType<Raven>> RAVEN = TFEntities.make(TFEntityNames.RAVEN, Raven::new, MobCategory.CREATURE, 0.3f, 0.5f, 17, 0x222233);
    public static final DeferredHolder<EntityType<?>, EntityType<Redcap>> REDCAP = TFEntities.make(TFEntityNames.REDCAP, Redcap::new, MobCategory.MONSTER, 0.9f, 1.4f, 3881580, 11214356, -0.4f);
    public static final DeferredHolder<EntityType<?>, EntityType<RedcapSapper>> REDCAP_SAPPER = TFEntities.make(TFEntityNames.REDCAP_SAPPER, RedcapSapper::new, MobCategory.MONSTER, 0.9f, 1.4f, 5725473, 11214356, -0.4f);
    public static final DeferredHolder<EntityType<?>, EntityType<RisingZombie>> RISING_ZOMBIE = TFEntities.buildNoEgg(TFEntityNames.RISING_ZOMBIE, EntityType.Builder.of(RisingZombie::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.74f).passengerAttachments(new float[]{2.0125f}).ridingOffset(-0.7f).clientTrackingRange(16), false);
    public static final DeferredHolder<EntityType<?>, EntityType<RovingCube>> ROVING_CUBE = TFEntities.make(TFEntityNames.ROVING_CUBE, RovingCube::new, MobCategory.MONSTER, 1.2f, 2.1f, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<SeekerArrow>> SEEKER_ARROW = TFEntities.buildNoEgg(TFEntityNames.SEEKER_ARROW, TFEntities.makeCastedBuilder(SeekerArrow.class, SeekerArrow::new, 0.5f, 0.5f, 150, 1), false);
    public static final DeferredHolder<EntityType<?>, EntityType<SkeletonDruid>> SKELETON_DRUID = TFEntities.make(TFEntityNames.SKELETON_DRUID, SkeletonDruid::new, MobCategory.MONSTER, 0.6f, 1.99f, 0xA3A3A3, 2767639, -0.7f);
    public static final DeferredHolder<EntityType<?>, EntityType<SlideBlock>> SLIDER = TFEntities.buildNoEgg(TFEntityNames.SLIDER, TFEntities.makeCastedBuilder(SlideBlock.class, SlideBlock::new, 0.98f, 0.98f, 80, 1), false);
    public static final DeferredHolder<EntityType<?>, EntityType<SlimeBeetle>> SLIME_BEETLE = TFEntities.make(TFEntityNames.SLIME_BEETLE, SlimeBeetle::new, MobCategory.MONSTER, 0.9f, 0.5f, 792070, 6334284);
    public static final DeferredHolder<EntityType<?>, EntityType<SlimeProjectile>> SLIME_BLOB = TFEntities.buildNoEgg(TFEntityNames.SLIME_BLOB, TFEntities.makeCastedBuilder(SlimeProjectile.class, SlimeProjectile::new, 0.25f, 0.25f, 150, 3), false);
    public static final DeferredHolder<EntityType<?>, EntityType<SnowGuardian>> SNOW_GUARDIAN = TFEntities.make(TFEntityNames.SNOW_GUARDIAN, SnowGuardian::new, MobCategory.MONSTER, 0.6f, 1.8f, 13887420, 0xFEFEFE);
    public static final DeferredHolder<EntityType<?>, EntityType<SnowQueen>> SNOW_QUEEN = TFEntities.make(TFEntityNames.SNOW_QUEEN, SnowQueen::new, MobCategory.MONSTER, 0.7f, 2.5f, 11645652, 8847470);
    public static final DeferredHolder<EntityType<?>, EntityType<Squirrel>> SQUIRREL = TFEntities.make(TFEntityNames.SQUIRREL, Squirrel::new, MobCategory.CREATURE, 0.3f, 0.5f, 9457426, 0xEEEEEE);
    public static final DeferredHolder<EntityType<?>, EntityType<StableIceCore>> STABLE_ICE_CORE = TFEntities.make(TFEntityNames.STABLE_ICE_CORE, StableIceCore::new, MobCategory.MONSTER, 0.8f, 1.8f, 1.35f, false, 10600435, 7340280);
    public static final DeferredHolder<EntityType<?>, EntityType<SwarmSpider>> SWARM_SPIDER = TFEntities.make(TFEntityNames.SWARM_SPIDER, SwarmSpider::new, MobCategory.MONSTER, 0.8f, 0.4f, 3277358, 1516830);
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownBlock>> THROWN_BLOCK = TFEntities.buildNoEgg(TFEntityNames.THROWN_BLOCK, TFEntities.makeCastedBuilder(ThrownBlock.class, ThrownBlock::new, 1.0f, 1.0f, 80, 2), true);
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownWep>> THROWN_WEP = TFEntities.make(TFEntityNames.THROWN_WEP, ThrownWep::new, MobCategory.MISC, 0.5f, 0.5f, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<TinyBird>> TINY_BIRD = TFEntities.make(TFEntityNames.TINY_BIRD, TinyBird::new, MobCategory.CREATURE, 0.3f, 0.3f, 0x33AADD, 0x1188EE);
    public static final DeferredHolder<EntityType<?>, EntityType<TomeBolt>> TOME_BOLT = TFEntities.buildNoEgg(TFEntityNames.TOME_BOLT, TFEntities.makeCastedBuilder(TomeBolt.class, TomeBolt::new, 0.25f, 0.25f, 150, 5), false);
    public static final DeferredHolder<EntityType<?>, EntityType<TowerwoodBorer>> TOWERWOOD_BORER = TFEntities.make(TFEntityNames.TOWERWOOD_BORER, TowerwoodBorer::new, MobCategory.MONSTER, 0.4f, 0.3f, 6105889, 11313210);
    public static final DeferredHolder<EntityType<?>, EntityType<Troll>> TROLL = TFEntities.make(TFEntityNames.TROLL, Troll::new, MobCategory.MONSTER, 1.4f, 2.4f, 10398095, 11572366);
    public static final DeferredHolder<EntityType<?>, EntityType<TwilightWandBolt>> WAND_BOLT = TFEntities.buildNoEgg(TFEntityNames.WAND_BOLT, TFEntities.makeCastedBuilder(TwilightWandBolt.class, TwilightWandBolt::new, 0.25f, 0.25f, 150, 5), false);
    public static final DeferredHolder<EntityType<?>, EntityType<UnstableIceCore>> UNSTABLE_ICE_CORE = TFEntities.make(TFEntityNames.UNSTABLE_ICE_CORE, UnstableIceCore::new, MobCategory.MONSTER, 0.8f, 1.8f, 1.35f, false, 10136821, 10162085);
    public static final DeferredHolder<EntityType<?>, EntityType<UpperGoblinKnight>> UPPER_GOBLIN_KNIGHT = TFEntities.make(TFEntityNames.UPPER_GOBLIN_KNIGHT, UpperGoblinKnight::new, MobCategory.MONSTER, 1.1f, 1.3f, 0, 0);
    public static final DeferredHolder<EntityType<?>, EntityType<UrGhast>> UR_GHAST = TFEntities.make(TFEntityNames.UR_GHAST, UrGhast::new, MobCategory.MONSTER, 14.0f, 18.0f, true, 0xBCBCBC, 0xB77878);
    public static final DeferredHolder<EntityType<?>, EntityType<WinterWolf>> WINTER_WOLF = TFEntities.make(TFEntityNames.WINTER_WOLF, WinterWolf::new, MobCategory.MONSTER, 1.4f, 1.9f, 1.45f, false, 14672869, 11713738);
    public static final DeferredHolder<EntityType<?>, EntityType<Wraith>> WRAITH = TFEntities.make(TFEntityNames.WRAITH, Wraith::new, MobCategory.MONSTER, 0.6f, 2.1f, true, 0x505050, 0x838383);
    public static final DeferredHolder<EntityType<?>, EntityType<Yeti>> YETI = TFEntities.make(TFEntityNames.YETI, Yeti::new, MobCategory.MONSTER, 1.4f, 2.4f, 0xDEDEDE, 4617659);

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, int primary, int secondary) {
        return TFEntities.make(id, factory, classification, width, height, primary, secondary, 0.0f);
    }

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, int primary, int secondary, float ridingOffset) {
        return TFEntities.make(id, factory, classification, width, height, false, primary, secondary, ridingOffset);
    }

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, boolean fireproof, int primary, int secondary) {
        return TFEntities.make(id, factory, classification, width, height, fireproof, primary, secondary, 0.0f);
    }

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, boolean fireproof, int primary, int secondary, float ridingOffset) {
        return TFEntities.build(id, TFEntities.makeBuilder(factory, classification, width, height, 80, 3, ridingOffset), fireproof, primary, secondary);
    }

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, float eyeHeight, boolean fireproof, int primary, int secondary) {
        return TFEntities.make(id, factory, classification, width, height, eyeHeight, fireproof, primary, secondary, 0.0f);
    }

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> make(ResourceLocation id, EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, float eyeHeight, boolean fireproof, int primary, int secondary, float ridingOffset) {
        return TFEntities.build(id, TFEntities.makeBuilder(factory, classification, width, height, 80, 3, ridingOffset).eyeHeight(eyeHeight), fireproof, primary, secondary);
    }

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> buildNoEgg(ResourceLocation id, EntityType.Builder<E> builder, boolean fireproof) {
        if (fireproof) {
            builder.fireImmune();
        }
        return ENTITIES.register(id.getPath(), () -> builder.build(id.toString()));
    }

    private static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> build(ResourceLocation id, EntityType.Builder<E> builder, boolean fireproof, int primary, int secondary) {
        if (fireproof) {
            builder.fireImmune();
        }
        DeferredHolder ret = ENTITIES.register(id.getPath(), () -> builder.build(id.toString()));
        if (primary != 0 && secondary != 0) {
            SPAWN_EGGS.register(id.getPath() + "_spawn_egg", () -> new DeferredSpawnEggItem(() -> (EntityType)ret.get(), primary, secondary, new Item.Properties()));
        }
        return ret;
    }

    private static <E extends Entity> EntityType.Builder<E> makeCastedBuilder(Class<E> cast, EntityType.EntityFactory<E> factory, float width, float height, int range, int interval) {
        return TFEntities.makeBuilder(factory, MobCategory.MISC, width, height, range, interval, 0.0f);
    }

    private static <E extends Entity> EntityType.Builder<E> makeBuilder(EntityType.EntityFactory<E> factory, MobCategory classification, float width, float height, int range, int interval, float ridingOffset) {
        return EntityType.Builder.of(factory, (MobCategory)classification).sized(width, height).setTrackingRange(range).setUpdateInterval(interval).setShouldReceiveVelocityUpdates(true).ridingOffset(ridingOffset);
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)BOAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)BIGHORN_SHEEP.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)DEER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)REDCAP.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)SKELETON_DRUID.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SkeletonDruid::checkDruidSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WRAITH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wraith::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HOSTILE_WOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HostileWolf::checkWolfSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HYDRA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)LICH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)PENGUIN.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Penguin::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)LICH_MINION.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)LOYAL_ZOMBIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)TINY_BIRD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)SQUIRREL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)DWARF_RABBIT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)RAVEN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)QUEST_RAM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)KOBOLD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)MOSQUITO_SWARM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)DEATH_TOME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)MINOTAUR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)MINOSHROOM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)FIRE_BEETLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)SLIME_BEETLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)PINCH_BEETLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)MIST_WOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_GHASTLING.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CarminiteGhastling::canSpawnHere, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)TOWERWOOD_BORER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_GHASTGUARD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CarminiteGhastguard::ghastSpawnHandler, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UR_GHAST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)BLOCKCHAIN_GOBLIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UPPER_GOBLIN_KNIGHT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)LOWER_GOBLIN_KNIGHT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HELMET_CRAB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)KNIGHT_PHANTOM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)NAGA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)SWARM_SPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SwarmSpider::getCanSpawnHere, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)KING_SPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)CARMINITE_BROODLING.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HEDGE_SPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HedgeSpider::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)REDCAP_SAPPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)MAZE_SLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MazeSlime::getCanSpawnHere, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)YETI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Yeti::yetiSnowyForestSpawnHandler, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ALPHA_YETI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)WINTER_WOLF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WinterWolf::canSpawnHere, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)SNOW_GUARDIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)STABLE_ICE_CORE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)UNSTABLE_ICE_CORE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)SNOW_QUEEN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)TROLL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)GIANT_MINER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GiantMiner::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ARMORED_GIANT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GiantMiner::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ICE_CRYSTAL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HARBINGER_CUBE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ADHERENT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ROVING_CUBE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)RISING_ZOMBIE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOAR.get(), Boar.registerAttributes().build());
        event.put((EntityType)BIGHORN_SHEEP.get(), Sheep.createAttributes().build());
        event.put((EntityType)DEER.get(), Deer.registerAttributes().build());
        event.put((EntityType)REDCAP.get(), Redcap.registerAttributes().build());
        event.put((EntityType)SWARM_SPIDER.get(), SwarmSpider.registerAttributes().build());
        event.put((EntityType)NAGA.get(), Naga.registerAttributes().build());
        event.put((EntityType)SKELETON_DRUID.get(), AbstractSkeleton.createAttributes().build());
        event.put((EntityType)HOSTILE_WOLF.get(), HostileWolf.registerAttributes().build());
        event.put((EntityType)WRAITH.get(), Wraith.registerAttributes().build());
        event.put((EntityType)HEDGE_SPIDER.get(), Spider.createAttributes().build());
        event.put((EntityType)HYDRA.get(), Hydra.registerAttributes().build());
        event.put((EntityType)LICH.get(), Lich.registerAttributes().build());
        event.put((EntityType)PENGUIN.get(), Penguin.registerAttributes().build());
        event.put((EntityType)LICH_MINION.get(), Zombie.createAttributes().build());
        event.put((EntityType)LOYAL_ZOMBIE.get(), LoyalZombie.registerAttributes().build());
        event.put((EntityType)TINY_BIRD.get(), TinyBird.registerAttributes().build());
        event.put((EntityType)SQUIRREL.get(), Squirrel.registerAttributes().build());
        event.put((EntityType)DWARF_RABBIT.get(), DwarfRabbit.registerAttributes().build());
        event.put((EntityType)RAVEN.get(), Raven.registerAttributes().build());
        event.put((EntityType)QUEST_RAM.get(), QuestRam.registerAttributes().build());
        event.put((EntityType)KOBOLD.get(), Kobold.registerAttributes().build());
        event.put((EntityType)MOSQUITO_SWARM.get(), MosquitoSwarm.registerAttributes().build());
        event.put((EntityType)DEATH_TOME.get(), DeathTome.registerAttributes().build());
        event.put((EntityType)MINOTAUR.get(), Minotaur.registerAttributes().build());
        event.put((EntityType)MINOSHROOM.get(), Minoshroom.registerAttributes().build());
        event.put((EntityType)FIRE_BEETLE.get(), FireBeetle.registerAttributes().build());
        event.put((EntityType)SLIME_BEETLE.get(), SlimeBeetle.registerAttributes().build());
        event.put((EntityType)PINCH_BEETLE.get(), PinchBeetle.registerAttributes().build());
        event.put((EntityType)MAZE_SLIME.get(), MazeSlime.registerAttributes().build());
        event.put((EntityType)REDCAP_SAPPER.get(), RedcapSapper.registerAttributes().build());
        event.put((EntityType)MIST_WOLF.get(), MistWolf.registerAttributes().build());
        event.put((EntityType)KING_SPIDER.get(), KingSpider.registerAttributes().build());
        event.put((EntityType)CARMINITE_GHASTLING.get(), CarminiteGhastling.registerAttributes().build());
        event.put((EntityType)CARMINITE_GHASTGUARD.get(), CarminiteGhastguard.registerAttributes().build());
        event.put((EntityType)CARMINITE_GOLEM.get(), CarminiteGolem.registerAttributes().build());
        event.put((EntityType)TOWERWOOD_BORER.get(), TowerwoodBorer.registerAttributes().build());
        event.put((EntityType)CARMINITE_BROODLING.get(), TowerBroodling.registerAttributes().build());
        event.put((EntityType)UR_GHAST.get(), UrGhast.registerAttributes().build());
        event.put((EntityType)BLOCKCHAIN_GOBLIN.get(), BlockChainGoblin.registerAttributes().build());
        event.put((EntityType)UPPER_GOBLIN_KNIGHT.get(), UpperGoblinKnight.registerAttributes().build());
        event.put((EntityType)LOWER_GOBLIN_KNIGHT.get(), LowerGoblinKnight.registerAttributes().build());
        event.put((EntityType)HELMET_CRAB.get(), HelmetCrab.registerAttributes().build());
        event.put((EntityType)KNIGHT_PHANTOM.get(), KnightPhantom.registerAttributes().build());
        event.put((EntityType)YETI.get(), Yeti.registerAttributes().build());
        event.put((EntityType)ALPHA_YETI.get(), AlphaYeti.registerAttributes().build());
        event.put((EntityType)WINTER_WOLF.get(), WinterWolf.registerAttributes().build());
        event.put((EntityType)SNOW_GUARDIAN.get(), SnowGuardian.registerAttributes().build());
        event.put((EntityType)STABLE_ICE_CORE.get(), StableIceCore.registerAttributes().build());
        event.put((EntityType)UNSTABLE_ICE_CORE.get(), UnstableIceCore.registerAttributes().build());
        event.put((EntityType)SNOW_QUEEN.get(), SnowQueen.registerAttributes().build());
        event.put((EntityType)TROLL.get(), Troll.registerAttributes().build());
        event.put((EntityType)GIANT_MINER.get(), GiantMiner.registerAttributes().build());
        event.put((EntityType)ARMORED_GIANT.get(), GiantMiner.registerAttributes().build());
        event.put((EntityType)ICE_CRYSTAL.get(), IceCrystal.registerAttributes().build());
        event.put((EntityType)HARBINGER_CUBE.get(), HarbingerCube.registerAttributes().build());
        event.put((EntityType)ADHERENT.get(), Adherent.registerAttributes().build());
        event.put((EntityType)ROVING_CUBE.get(), RovingCube.registerAttributes().build());
        event.put((EntityType)PLATEAU_BOSS.get(), PlateauBoss.registerAttributes().build());
        event.put((EntityType)RISING_ZOMBIE.get(), Zombie.createAttributes().build());
    }
}

