/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.util.entities.EntityUtil;

public class NatureBolt
extends TFThrowable
implements ITFProjectile,
ItemSupplier {
    public NatureBolt(EntityType<? extends NatureBolt> type, Level level) {
        super(type, level);
    }

    public NatureBolt(Level level, LivingEntity owner) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.NATURE_BOLT.get()), level, owner);
    }

    public void tick() {
        super.tick();
        this.makeTrail((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, 5);
    }

    protected double getDefaultGravity() {
        return 0.003f;
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_LEAVES.defaultBlockState()), false, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.05);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos blockPosHit = result.getBlockPos();
        BlockState stateHit = this.level().getBlockState(blockPosHit);
        if (EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            BonemealableBlock bonemealable;
            Block block;
            if (!this.level().isClientSide() && (block = stateHit.getBlock()) instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)this.level(), blockPosHit, stateHit)) {
                bonemealable.performBonemeal((ServerLevel)this.level(), this.random, blockPosHit, stateHit);
            } else if (stateHit.isSolid() && this.canReplaceBlock(this.level(), blockPosHit)) {
                this.level().setBlockAndUpdate(blockPosHit, (BlockState)Blocks.BIRCH_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity owner = this.getOwner();
        Entity entityHit = result.getEntity();
        if (entityHit instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityHit;
            if ((owner == null || entityHit != owner && entityHit != owner.getVehicle()) && entityHit.hurt(TFDamageTypes.getIndirectEntityDamageSource(this.level(), TFDamageTypes.LEAF_BRAIN, (Entity)this, this.getOwner(), new EntityType[0]), 2.0f) && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                int poisonTime = this.level().getDifficulty() == Difficulty.HARD ? 7 : 3;
                living.addEffect(new MobEffectInstance(MobEffects.POISON, poisonTime * 20, 0));
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    private boolean canReplaceBlock(Level level, BlockPos pos) {
        return !level.getBlockState(pos).hasBlockEntity() && level.getBlockState(pos).isSolidRender((BlockGetter)level, pos) && level.getBlockState(pos).is(BlockTagGenerator.DRUID_PROJECTILE_REPLACEABLE) && EntityUtil.canDestroyBlock(level, pos, (Entity)this);
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.WHEAT_SEEDS);
    }
}

