/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.monster.SkeletonDruid;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.util.landmarks.LegacyLandmarkPlacements;

public class SwarmSpider
extends Spider {
    public SwarmSpider(EntityType<? extends SwarmSpider> type, Level world) {
        super(type, world);
        this.xpReward = 2;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Spider.createAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.availableGoals.removeIf(t -> t.getGoal() instanceof MeleeAttackGoal);
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.availableGoals.removeIf(t -> t.getPriority() == 2 && t.getGoal() instanceof NearestAttackableTargetGoal);
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.SWARM_SPIDER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)TFSounds.SWARM_SPIDER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.SWARM_SPIDER_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)TFSounds.SWARM_SPIDER_STEP.get(), 0.15f, 1.0f);
    }

    public boolean doHurtTarget(Entity entity) {
        return this.getRandom().nextInt(4) == 0 && super.doHurtTarget(entity);
    }

    public EntityType<? extends SwarmSpider> getReinforcementType() {
        return (EntityType)TFEntities.SWARM_SPIDER.get();
    }

    public static boolean getCanSpawnHere(EntityType<? extends SwarmSpider> entity, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return accessor.getDifficulty() != Difficulty.PEACEFUL && SwarmSpider.isValidLightLevel(accessor, pos, random) && SwarmSpider.checkMobSpawnRules(entity, (LevelAccessor)accessor, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor accessor, BlockPos pos, RandomSource random) {
        int chunkZ;
        int chunkX = Mth.floor((float)pos.getX()) >> 4;
        return LegacyLandmarkPlacements.pickLandmarkForChunk(chunkX, chunkZ = Mth.floor((float)pos.getZ()) >> 4, (LevelReader)accessor) == TFStructures.HEDGE_MAZE || Monster.isDarkEnoughToSpawn((ServerLevelAccessor)accessor, (BlockPos)pos, (RandomSource)random);
    }

    public float getVoicePitch() {
        return (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.5f;
    }

    public int getMaxSpawnClusterSize() {
        return 6;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(accessor, difficulty, reason, data);
        this.summonJockey(accessor, difficulty);
        return data;
    }

    public void summonJockey(ServerLevelAccessor accessor, DifficultyInstance difficulty) {
        SkeletonDruid druid;
        if ((this.getFirstPassenger() != null || accessor.getRandom().nextInt(200) == 0) && (druid = (SkeletonDruid)((EntityType)TFEntities.SKELETON_DRUID.get()).create(this.level())) != null) {
            druid.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            druid.setBaby(true);
            EventHooks.finalizeMobSpawn((Mob)druid, (ServerLevelAccessor)accessor, (DifficultyInstance)difficulty, (MobSpawnType)MobSpawnType.JOCKEY, null);
            if (this.hasPassenger(e -> true)) {
                this.ejectPassengers();
            }
            druid.startRiding((Entity)this);
        }
    }
}

