/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.ai.goal.RiderSpearAttackGoal;
import twilightforest.entity.monster.UpperGoblinKnight;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class LowerGoblinKnight
extends Monster {
    private static final EntityDataAccessor<Boolean> ARMOR = SynchedEntityData.defineId(LowerGoblinKnight.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final AttributeModifier ARMOR_MODIFIER = new AttributeModifier(TwilightForestMod.prefix("armor_boost"), 17.0, AttributeModifier.Operation.ADD_VALUE);

    public LowerGoblinKnight(EntityType<? extends LowerGoblinKnight> type, Level world) {
        super(type, world);
        this.setHasArmor(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RiderSpearAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, false){

            public boolean canUse() {
                Object e;
                if (this.mob.isVehicle() && (e = this.mob.getPassengers().get(0)) instanceof UpperGoblinKnight) {
                    UpperGoblinKnight knight = (UpperGoblinKnight)((Object)e);
                    if (knight.heavySpearTimer > 0) {
                        return false;
                    }
                }
                return super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ARMOR, (Object)false);
    }

    public boolean hasArmor() {
        return (Boolean)this.getEntityData().get(ARMOR);
    }

    private void setHasArmor(boolean flag) {
        this.getEntityData().set(ARMOR, (Object)flag);
        if (!this.level().isClientSide()) {
            if (flag) {
                if (!Objects.requireNonNull(this.getAttribute(Attributes.ARMOR)).hasModifier(ARMOR_MODIFIER.id())) {
                    Objects.requireNonNull(this.getAttribute(Attributes.ARMOR)).addTransientModifier(ARMOR_MODIFIER);
                }
            } else {
                Objects.requireNonNull(this.getAttribute(Attributes.ARMOR)).removeModifier(ARMOR_MODIFIER.id());
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("hasArmor", this.hasArmor());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHasArmor(compound.getBoolean("hasArmor"));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(accessor, difficulty, reason, data);
        UpperGoblinKnight upper = new UpperGoblinKnight((EntityType<? extends UpperGoblinKnight>)((EntityType)TFEntities.UPPER_GOBLIN_KNIGHT.get()), this.level());
        upper.moveTo(this.getX(), this.getY() + 1.0, this.getZ(), this.getYRot(), 0.0f);
        EventHooks.finalizeMobSpawn((Mob)upper, (ServerLevelAccessor)accessor, (DifficultyInstance)difficulty, (MobSpawnType)MobSpawnType.NATURAL, (SpawnGroupData)data);
        upper.startRiding((Entity)this);
        return data;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float yRot) {
        return new Vec3(0.0, (double)(dimensions.height() * 0.91f), 0.0);
    }

    public boolean doHurtTarget(Entity entity) {
        Object e;
        if (this.isVehicle() && (e = this.getPassengers().get(0)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            return living.doHurtTarget(entity);
        }
        return super.doHurtTarget(entity);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.hasArmor() ? (SoundEvent)TFSounds.GOBLIN_KNIGHT_MUFFLED_AMBIENT.get() : (SoundEvent)TFSounds.GOBLIN_KNIGHT_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return this.hasArmor() ? (SoundEvent)TFSounds.GOBLIN_KNIGHT_MUFFLED_DEATH.get() : (SoundEvent)TFSounds.GOBLIN_KNIGHT_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return this.hasArmor() ? (SoundEvent)TFSounds.GOBLIN_KNIGHT_MUFFLED_HURT.get() : (SoundEvent)TFSounds.GOBLIN_KNIGHT_HURT.get();
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity attacker = null;
        if (source.getEntity() != null) {
            attacker = source.getEntity();
        }
        if (source.getEntity() != null) {
            attacker = source.getEntity();
        }
        if (attacker != null) {
            Object e;
            double dx = this.getX() - attacker.getX();
            double dz = this.getZ() - attacker.getZ();
            float angle = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float difference = Mth.abs((float)((this.yBodyRot - angle) % 360.0f));
            UpperGoblinKnight upper = null;
            if (this.isVehicle() && (e = this.getPassengers().get(0)) instanceof UpperGoblinKnight) {
                UpperGoblinKnight goblin;
                upper = goblin = (UpperGoblinKnight)((Object)e);
            }
            if (upper != null && upper.hasShield() && difference > 150.0f && difference < 230.0f && upper.takeHitOnShield(source, amount)) {
                return false;
            }
            if (this.hasArmor() && (difference > 300.0f || difference < 60.0f)) {
                this.breakArmor();
            }
        }
        return super.hurt(source, amount);
    }

    public void positionRider(Entity entity, Entity.MoveFunction callback) {
        super.positionRider(entity, callback);
        if (entity instanceof UpperGoblinKnight) {
            UpperGoblinKnight goblin = (UpperGoblinKnight)entity;
            goblin.setYBodyRot(this.getYRot());
            goblin.setYHeadRot(this.getYRot());
            goblin.setYRot(this.getYRot());
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 5) {
            ItemStack broken = new ItemStack((ItemLike)Items.IRON_CHESTPLATE);
            this.breakItem(broken);
            this.breakItem(broken);
            this.breakItem(broken);
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void breakArmor() {
        this.level().broadcastEntityEvent((Entity)this, (byte)5);
        this.setHasArmor(false);
    }
}

