/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.monster.CarminiteGhastguard;

public class GhastguardHomedFlightGoal
extends Goal {
    private final CarminiteGhastguard ghast;

    public GhastguardHomedFlightGoal(CarminiteGhastguard ghast) {
        this.ghast = ghast;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        double d2;
        double d1;
        MoveControl control = this.ghast.getMoveControl();
        if (!control.hasWanted()) {
            return !this.ghast.isMobWithinHomeArea((Entity)this.ghast);
        }
        double d0 = control.getWantedX() - this.ghast.getX();
        double d3 = d0 * d0 + (d1 = control.getWantedY() - this.ghast.getY()) * d1 + (d2 = control.getWantedZ() - this.ghast.getZ()) * d2;
        return (d3 < 1.0 || d3 > 3600.0) && !this.ghast.isMobWithinHomeArea((Entity)this.ghast);
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        if (!this.ghast.isRestrictionPointValid(this.ghast.level().dimension())) {
            this.stop();
            return;
        }
        RandomSource random = this.ghast.getRandom();
        double d0 = this.ghast.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.ghast.getWanderFactor());
        double d1 = this.ghast.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.ghast.getWanderFactor());
        double d2 = this.ghast.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.ghast.getWanderFactor());
        this.ghast.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
        if (this.ghast.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)this.ghast.getRestrictionPoint().pos())) > 256.0) {
            Vec3 vecToHome = Vec3.atLowerCornerOf((Vec3i)this.ghast.getRestrictionPoint().pos()).subtract(this.ghast.position()).normalize();
            double targetX = this.ghast.getX() + vecToHome.x() * (double)this.ghast.getWanderFactor() + (double)((this.ghast.getRandom().nextFloat() * 2.0f - 1.0f) * this.ghast.getWanderFactor());
            double targetY = this.ghast.getY() + vecToHome.y() * (double)this.ghast.getWanderFactor() + (double)((this.ghast.getRandom().nextFloat() * 2.0f - 1.0f) * this.ghast.getWanderFactor());
            double targetZ = this.ghast.getZ() + vecToHome.z() * (double)this.ghast.getWanderFactor() + (double)((this.ghast.getRandom().nextFloat() * 2.0f - 1.0f) * this.ghast.getWanderFactor());
            this.ghast.getMoveControl().setWantedPosition(targetX, targetY, targetZ, 1.0);
        } else {
            this.ghast.getMoveControl().setWantedPosition((double)this.ghast.getRestrictionPoint().pos().getX() + 0.5, (double)this.ghast.getRestrictionPoint().pos().getY(), (double)this.ghast.getRestrictionPoint().pos().getZ() + 0.5, 1.0);
        }
    }
}

