/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.ai.goal.AttemptToGoHomeGoal;
import twilightforest.init.TFDimension;

public interface EnforcedHomePoint {
    default public <T extends PathfinderMob> void addRestrictionGoals(T entity, GoalSelector selector) {
        selector.addGoal(5, new AttemptToGoHomeGoal<T>(entity, 1.25));
    }

    default public void saveHomePointToNbt(CompoundTag tag) {
        if (this.getRestrictionPoint() != null) {
            GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getRestrictionPoint()).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).ifPresent(tag1 -> tag.put("HomePos", tag1));
        }
    }

    default public void loadHomePointFromNbt(CompoundTag tag) {
        if (tag.contains("Home", 9)) {
            ListTag nbttaglist = tag.getList("Home", 6);
            double hx = nbttaglist.getDouble(0);
            double hy = nbttaglist.getDouble(1);
            double hz = nbttaglist.getDouble(2);
            this.setRestrictionPoint(GlobalPos.of(TFDimension.DIMENSION_KEY, (BlockPos)BlockPos.containing((double)hx, (double)hy, (double)hz)));
        } else if (tag.contains("HomePos")) {
            this.setRestrictionPoint(GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("HomePos")).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).orElse(null));
        }
    }

    default public boolean isMobWithinHomeArea(Entity entity) {
        if (!this.isRestrictionPointValid((ResourceKey<Level>)entity.level().dimension())) {
            return true;
        }
        return this.getRestrictionPoint().pos().distSqr((Vec3i)entity.blockPosition()) < (double)(this.getHomeRadius() * this.getHomeRadius());
    }

    default public boolean isRestrictionPointValid(ResourceKey<Level> currentMobLevel) {
        return this.getRestrictionPoint() != null && this.getRestrictionPoint().dimension().equals(currentMobLevel);
    }

    @Nullable
    public GlobalPos getRestrictionPoint();

    public void setRestrictionPoint(@Nullable GlobalPos var1);

    public int getHomeRadius();
}

