/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.components.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.alchemy.Potion;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.DrinkFromFlaskTrigger;
import twilightforest.init.TFAdvancements;

public class PotionFlaskTrackingAttachment {
    @Nullable
    private Holder<Potion> lastUsedPotion;
    private int dosesDrank;
    private long lastTimeStarted;
    public static final Codec<PotionFlaskTrackingAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.POTION.holderByNameCodec().optionalFieldOf("last_used_potion", null).forGetter(o -> o.lastUsedPotion), (App)Codec.INT.fieldOf("doses_drank").forGetter(o -> o.dosesDrank), (App)Codec.LONG.fieldOf("last_game_time_started").forGetter(o -> o.lastTimeStarted)).apply((Applicative)instance, PotionFlaskTrackingAttachment::new));

    public PotionFlaskTrackingAttachment() {
        this(null, 0, 0L);
    }

    public PotionFlaskTrackingAttachment(@Nullable Holder<Potion> lastUsedPotion, int dosesDrank, long timeStarted) {
        this.lastUsedPotion = lastUsedPotion;
        this.dosesDrank = dosesDrank;
        this.lastTimeStarted = timeStarted;
    }

    public void trackDrink(Holder<Potion> potion, ServerPlayer player) {
        if (this.lastUsedPotion == null || !Objects.equals(this.lastUsedPotion, potion)) {
            this.dosesDrank = 1;
            this.lastTimeStarted = player.level().getGameTime();
        } else {
            ++this.dosesDrank;
        }
        this.lastUsedPotion = potion;
        if (player.isAlive()) {
            ((DrinkFromFlaskTrigger)((Object)TFAdvancements.DRINK_FROM_FLASK.get())).trigger(player, this.dosesDrank, Mth.floor((float)((float)(player.level().getGameTime() - this.lastTimeStarted) / 20.0f)), this.lastUsedPotion);
        }
    }

    public void resetDoses() {
        this.dosesDrank = 0;
        this.lastUsedPotion = null;
    }
}

