/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.compat.emi.TFEmiRecipeCategory;

public abstract class TFEmiRecipe<T extends Recipe<?>>
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final RecipeHolder<T> recipe;
    private final ResourceLocation id;
    private final int width;
    private final int height;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;

    public TFEmiRecipe(TFEmiRecipeCategory category, RecipeHolder<T> recipe, int width, int height) {
        this.category = category;
        this.recipe = recipe;
        this.width = width;
        this.height = height;
        ResourceLocation recipeId = recipe.id();
        String path = String.format("emi/%s/%s/%s", category.name, recipeId.getNamespace(), recipeId.getPath());
        this.id = TwilightForestMod.prefix(path);
        this.inputs = new ArrayList<EmiIngredient>();
        this.addInputs(this.inputs);
        this.outputs = new ArrayList<EmiStack>();
        this.addOutputs(this.outputs);
    }

    protected abstract void addInputs(List<EmiIngredient> var1);

    protected abstract void addOutputs(List<EmiStack> var1);

    public RecipeHolder<T> getRecipe() {
        return this.recipe;
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }
}

