/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import twilightforest.beanification.Component;
import twilightforest.block.entity.spawner.SinisterSpawnerBlockEntity;

@Component
public class SinisterSpawnerCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_LOOT_TABLE = (context, builder) -> {
        ReloadableServerRegistries.Holder holder = ((CommandSourceStack)context.getSource()).getServer().reloadableRegistries();
        return SharedSuggestionProvider.suggestResource((Iterable)holder.getKeys(Registries.LOOT_TABLE), (SuggestionsBuilder)builder);
    };

    public LiteralArgumentBuilder<CommandSourceStack> register(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sinister_spawner").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"add_particle").then(Commands.argument((String)"particle", (ArgumentType)ParticleArgument.particle((CommandBuildContext)buildContext)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(this::addParticle))))).then(Commands.literal((String)"remove_particle").then(Commands.argument((String)"particle", (ArgumentType)ParticleArgument.particle((CommandBuildContext)buildContext)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(this::removeParticle))))).then(Commands.literal((String)"set_loot").then(Commands.argument((String)"loot", (ArgumentType)ResourceOrIdArgument.lootTable((CommandBuildContext)buildContext)).suggests(SUGGEST_LOOT_TABLE).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(this::setLootTable))))).then(Commands.literal((String)"clear_loot").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(this::clearLootTable)));
    }

    private int addParticle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SinisterSpawnerBlockEntity entity;
        ParticleOptions options = ParticleArgument.getParticle(context, (String)"particle");
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(pos);
        if (blockEntity instanceof SinisterSpawnerBlockEntity && (entity = (SinisterSpawnerBlockEntity)blockEntity).addParticle(options, true)) {
            return 1;
        }
        return 0;
    }

    private int removeParticle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SinisterSpawnerBlockEntity entity;
        ParticleOptions options = ParticleArgument.getParticle(context, (String)"particle");
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(pos);
        if (blockEntity instanceof SinisterSpawnerBlockEntity && (entity = (SinisterSpawnerBlockEntity)blockEntity).removeParticle(options, true)) {
            return 1;
        }
        return 0;
    }

    private int setLootTable(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SinisterSpawnerBlockEntity entity;
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        Holder loot = ResourceOrIdArgument.getLootTable(context, (String)"loot");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(pos);
        if (blockEntity instanceof SinisterSpawnerBlockEntity && (entity = (SinisterSpawnerBlockEntity)blockEntity).setLootTable((ResourceKey<LootTable>)loot.getKey())) {
            return 1;
        }
        return 0;
    }

    private int clearLootTable(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SinisterSpawnerBlockEntity entity;
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).getLevel().getBlockEntity(pos);
        if (blockEntity instanceof SinisterSpawnerBlockEntity && (entity = (SinisterSpawnerBlockEntity)blockEntity).setLootTable(null)) {
            return 1;
        }
        return 0;
    }
}

