/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import twilightforest.config.TFConfig;
import twilightforest.entity.monster.GiantMiner;

public class TFGiantRenderer<T extends GiantMiner>
extends MobRenderer<T, PlayerModel<T>> {
    private final PlayerModel<T> normalModel = (PlayerModel)this.getModel();
    private final PlayerModel<T> slimModel;

    public TFGiantRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 1.8f);
        this.slimModel = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.addLayer(new GiantItemInHandLayer(this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
    }

    public ResourceLocation getTextureLocation(GiantMiner entity) {
        GameProfile profile;
        Minecraft mc = Minecraft.getInstance();
        ResourceLocation texture = DefaultPlayerSkin.getDefaultTexture();
        this.model = this.normalModel;
        GameProfile gameProfile = profile = TFConfig.GAME_PROFILES.isEmpty() ? null : TFConfig.GAME_PROFILES.get(Math.abs((int)entity.getUUID().getMostSignificantBits()) % TFConfig.GAME_PROFILES.size());
        if (profile != null) {
            PlayerSkin skin = mc.getSkinManager().getInsecureSkin(profile);
            texture = skin.texture();
            if (skin.model().id().equals("slim")) {
                this.model = this.slimModel;
            }
        } else {
            Entity entity2 = mc.getCameraEntity();
            if (entity2 instanceof AbstractClientPlayer) {
                AbstractClientPlayer client = (AbstractClientPlayer)entity2;
                texture = client.getSkin().texture();
                if (client.getSkin().model().id().equals("slim")) {
                    this.model = this.slimModel;
                }
            }
        }
        return texture;
    }

    public void scale(T entity, PoseStack stack, float partialTicks) {
        float scale = 4.0f;
        stack.scale(scale, scale, scale);
    }

    public static class GiantItemInHandLayer<T extends LivingEntity, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer handRenderer;

        public GiantItemInHandLayer(RenderLayerParent<T, M> renderer, ItemInHandRenderer handRenderer) {
            super(renderer);
            this.handRenderer = handRenderer;
        }

        public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack1;
            boolean flag = entity.getMainArm() == HumanoidArm.RIGHT;
            ItemStack itemstack = flag ? entity.getOffhandItem() : entity.getMainHandItem();
            ItemStack itemStack = itemstack1 = flag ? entity.getMainHandItem() : entity.getOffhandItem();
            if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
                stack.pushPose();
                if (this.getParentModel().young) {
                    stack.translate(0.0, 0.75, 0.0);
                    stack.scale(0.5f, 0.5f, 0.5f);
                }
                this.renderArmWithItem((LivingEntity)entity, itemstack1, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, stack, buffer, light);
                this.renderArmWithItem((LivingEntity)entity, itemstack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, stack, buffer, light);
                stack.popPose();
            }
        }

        protected void renderArmWithItem(LivingEntity entity, ItemStack stack, ItemDisplayContext type, HumanoidArm arm, PoseStack ms, MultiBufferSource buffer, int light) {
            if (!stack.isEmpty()) {
                ms.pushPose();
                ((ArmedModel)this.getParentModel()).translateToHand(arm, ms);
                ms.mulPose(Axis.XP.rotationDegrees(-90.0f));
                ms.mulPose(Axis.YP.rotationDegrees(180.0f));
                boolean flag = arm == HumanoidArm.LEFT;
                ms.translate((double)((float)(flag ? -1 : 1) / 16.0f), 0.0, -0.5);
                ms.scale(0.25f, 0.25f, 0.25f);
                this.handRenderer.renderItem(entity, stack, type, flag, ms, buffer, light);
                ms.popPose();
            }
        }
    }
}

