/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.RisingZombieModel;
import twilightforest.client.renderer.entity.TFBipedRenderer;
import twilightforest.entity.monster.RisingZombie;

public class RisingZombieRenderer
extends TFBipedRenderer<RisingZombie, RisingZombieModel> {
    public RisingZombieRenderer(EntityRendererProvider.Context context) {
        super(context, new RisingZombieModel(context.bakeLayer(TFModelLayers.RISING_ZOMBIE)), new RisingZombieModel(context.bakeLayer(ModelLayers.ZOMBIE_INNER_ARMOR)), new RisingZombieModel(context.bakeLayer(ModelLayers.ZOMBIE_OUTER_ARMOR)), 0.5f, "textures/entity/zombie/zombie.png");
    }

    protected float getShadowRadius(RisingZombie entity) {
        return 0.5f * ((float)entity.getRisingTicks() / 130.0f);
    }

    @Nullable
    protected RenderType getRenderType(RisingZombie entity, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (translucent) {
            return ((RisingZombieModel)this.model).renderType(this.getTextureLocation(entity));
        }
        return super.getRenderType((LivingEntity)entity, bodyVisible, translucent, glowing);
    }

    protected void setupRotations(RisingZombie entity, PoseStack stack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)entity, stack, bob, yBodyRot, partialTick, scale);
        int tick = entity.getRisingTicks();
        stack.translate(0.0f, -(80.0f - Math.min(80.0f, (float)tick)) / 80.0f, 0.0f);
        stack.translate(0.0f, -(40.0f - Math.min(40.0f, Math.max(0.0f, (float)tick - 80.0f))) / 40.0f, 0.0f);
        float yOff = 1.0f;
        stack.translate(0.0f, 1.0f, 0.0f);
        stack.mulPose(Axis.XP.rotationDegrees(120.0f * (80.0f - Math.min(80.0f, (float)tick)) / 80.0f));
        stack.mulPose(Axis.XP.rotationDegrees(-30.0f * (40.0f - Math.min(40.0f, Math.max(0.0f, (float)tick - 80.0f))) / 40.0f));
        stack.translate(0.0f, -1.0f, 0.0f);
    }

    protected float getFlipDegrees(RisingZombie livingEntity) {
        return 0.0f;
    }
}

