/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TFSkyRenderer {
    private static VertexBuffer starBuffer;

    public static boolean renderSky(ClientLevel level, float partialTicks, Matrix4f frustumMatrix, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
        PoseStack stack = new PoseStack();
        stack.mulPose(frustumMatrix);
        setupFog.run();
        Vec3 vec3 = level.getSkyColor(camera.getPosition(), partialTicks);
        float f = (float)vec3.x();
        float f1 = (float)vec3.y();
        float f2 = (float)vec3.z();
        FogRenderer.levelFogColor();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        levelRenderer.skyBuffer.bind();
        levelRenderer.skyBuffer.drawWithShader(stack.last().pose(), projectionMatrix, shaderinstance);
        VertexBuffer.unbind();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        stack.pushPose();
        float f11 = 1.0f - level.getRainLevel(partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        stack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTicks) * 360.0f));
        float f10 = 1.0f;
        RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
        FogRenderer.setupNoFog();
        starBuffer.bind();
        starBuffer.drawWithShader(stack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
        VertexBuffer.unbind();
        setupFog.run();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        stack.popPose();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d0 = camera.getEntity().getEyePosition(partialTicks).y() - (double)level.getMinBuildHeight();
        if (d0 < 0.0) {
            stack.pushPose();
            stack.translate(0.0f, 12.0f, 0.0f);
            levelRenderer.darkBuffer.bind();
            levelRenderer.darkBuffer.drawWithShader(stack.last().pose(), projectionMatrix, shaderinstance);
            VertexBuffer.unbind();
            stack.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        return true;
    }

    public static void createStars() {
        if (starBuffer != null) {
            starBuffer.close();
        }
        starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        starBuffer.bind();
        starBuffer.upload(TFSkyRenderer.drawStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    private static MeshData drawStars(Tesselator tesselator) {
        RandomSource random = RandomSource.create((long)10842L);
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < 3000; ++i) {
            float f1 = random.nextFloat() * 2.0f - 1.0f;
            float f2 = random.nextFloat() * 2.0f - 1.0f;
            float f3 = random.nextFloat() * 2.0f - 1.0f;
            float f4 = 0.15f + random.nextFloat() * 0.1f;
            float f5 = Mth.lengthSquared((float)f1, (float)f2, (float)f3);
            if (f5 <= 0.010000001f || f5 >= 1.0f) continue;
            Vector3f vector3f = new Vector3f(f1, f2, f3).normalize(100.0f);
            float f6 = (float)(random.nextDouble() * 3.1415927410125732 * 2.0);
            Quaternionf quaternionf = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)vector3f).rotateZ(f6);
            bufferbuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(f4, -f4, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferbuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(f4, f4, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferbuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-f4, f4, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferbuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-f4, -f4, 0.0f).rotate((Quaternionfc)quaternionf)));
        }
        return bufferbuilder.buildOrThrow();
    }
}

