/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.BaseIceMob;

public class UnstableIceCoreModel<T extends BaseIceMob>
extends HierarchicalModel<T> {
    protected final ModelPart[] spikes = new ModelPart[16];
    protected final ModelPart[] cubes = new ModelPart[16];
    private final ModelPart root;
    protected boolean alive;

    public UnstableIceCoreModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        int i;
        this.root = root;
        for (i = 0; i < this.spikes.length; ++i) {
            this.spikes[i] = root.getChild("spike_" + i);
        }
        for (i = 0; i < this.cubes.length; ++i) {
            this.cubes[i] = this.spikes[i].getChild("cube_" + i);
        }
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        for (int i = 0; i < 16; ++i) {
            float spikeLength = i % 2 == 0 ? 6.0f : 8.0f;
            PartDefinition spike = partdefinition.addOrReplaceChild("spike_" + i, CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 4.0f, -1.0f, 2.0f, spikeLength, 2.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
            spike.addOrReplaceChild("cube_" + i, CubeListBuilder.create().texOffs(8, 16).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        this.root().render(stack, builder, light, overlay, FastColor.ARGB32.color((int)((int)((float)FastColor.ARGB32.alpha((int)color) * (this.alive ? 0.6f : 1.0f))), (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color)));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.alive = entity.isAlive();
        for (int i = 0; i < this.spikes.length; ++i) {
            this.spikes[i].yRot = ((float)((BaseIceMob)((Object)entity)).tickCount + partialTicks) / 5.0f;
            this.spikes[i].xRot = Mth.sin((float)(((float)((BaseIceMob)((Object)entity)).tickCount + partialTicks) / 5.0f)) / 4.0f;
            this.spikes[i].zRot = Mth.cos((float)(((float)((BaseIceMob)((Object)entity)).tickCount + partialTicks) / 5.0f)) / 4.0f;
            this.spikes[i].xRot += (float)i * 5.0f;
            this.spikes[i].yRot += (float)i * 2.5f;
            this.spikes[i].zRot += (float)i * 3.0f;
            this.spikes[i].x = Mth.cos((float)(((float)((BaseIceMob)((Object)entity)).tickCount + partialTicks) / (float)i)) * 3.0f;
            this.spikes[i].y = 5.0f + Mth.sin((float)(((float)((BaseIceMob)((Object)entity)).tickCount + partialTicks) / (float)i)) * 3.0f;
            this.spikes[i].z = Mth.sin((float)(((float)((BaseIceMob)((Object)entity)).tickCount + partialTicks) / (float)i)) * 3.0f;
            this.cubes[i].y = 10.0f + Mth.sin((float)(((float)(i + ((BaseIceMob)((Object)entity)).tickCount) + partialTicks) / (float)i)) * 3.0f;
        }
    }
}

