/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.passive.Raven;

public class RavenModel
extends HierarchicalModel<Raven> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public RavenModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        ModelPart body = root.getChild("body");
        this.rightWing = body.getChild("right_wing");
        this.leftWing = body.getChild("left_wing");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? RavenModel.createJappaModel() : RavenModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition base = meshdefinition.getRoot();
        PartDefinition head = base.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        head.addOrReplaceChild("beak1", CubeListBuilder.create().texOffs(12, 0).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.5f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("beak2", CubeListBuilder.create().texOffs(12, 0).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.5f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition body = base.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)1.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.5f, 1.0f, 3.0f, 6.0f), PartPose.offset((float)-1.5f, (float)0.0f, (float)1.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, -1.5f, 1.0f, 3.0f, 6.0f), PartPose.offset((float)1.5f, (float)0.0f, (float)1.0f));
        PartDefinition rightLeg = base.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(14, 16).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)-1.5f, (float)21.0f, (float)1.0f));
        rightLeg.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(14, 20).addBox(0.0f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)1.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = base.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(14, 16).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)0.5f, (float)21.0f, (float)1.0f));
        leftLeg.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(14, 20).addBox(0.0f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)1.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 25).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)4.5f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f).texOffs(9, 0).addBox(-0.5f, 0.0f, -3.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)18.5f, (float)-2.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 6).addBox(-2.0f, -1.5f, 0.0f, 4.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)18.5f, (float)-2.0f, (float)-0.43633232f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 15).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)2.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(14, 15).addBox(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)2.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(8, 15).addBox(0.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(14, 15).addBox(0.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(8, 0).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)6.0f, (float)-0.43633232f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(Raven entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.zRot = netHeadYaw > 5.0f ? -0.2617994f : 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.zRot = ageInTicks;
        this.leftWing.zRot = -ageInTicks;
        if (entity.isBirdLanded()) {
            this.rightLeg.y = 21.0f;
            this.leftLeg.y = 21.0f;
        } else {
            this.rightLeg.y = 20.0f;
            this.leftLeg.y = 20.0f;
        }
    }
}

