/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.QuestRamRenderer;
import twilightforest.entity.passive.QuestRam;

public class QuestRamModel<T extends QuestRam>
extends HierarchicalModel<T>
implements TrophyBlockModel {
    private final ModelPart root;
    private final ModelPart head;
    private ModelPart neck;
    private ModelPart frontTorso;
    private ModelPart backTorso;
    private ModelPart leftFrontLeg;
    private ModelPart rightFrontLeg;
    private ModelPart leftBackLeg;
    private ModelPart rightBackLeg;
    private final ModelPart[] segments = new ModelPart[16];
    final int[] colorOrder = new int[]{0, 8, 7, 15, 14, 1, 4, 5, 13, 3, 9, 11, 10, 2, 6, 12};

    public QuestRamModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        if (root.hasChild("neck")) {
            this.neck = root.getChild("neck");
            this.frontTorso = root.getChild("front_torso");
            this.backTorso = root.getChild("back_torso");
            this.leftFrontLeg = root.getChild("left_front_leg");
            this.rightFrontLeg = root.getChild("right_front_leg");
            this.leftBackLeg = root.getChild("left_back_leg");
            this.rightBackLeg = root.getChild("right_back_leg");
            Arrays.setAll(this.segments, num -> root.getChild(QuestRamModel.getSegmentName(num)));
            for (int i = 0; i < 16; ++i) {
                this.segments[i].visible = false;
            }
        }
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? QuestRamModel.createJappaModel() : QuestRamModel.create();
    }

    public static LayerDefinition checkForPackTrophyEdition() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? QuestRamModel.createJappaTrophy() : QuestRamModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 70).addBox(-6.0f, -5.0f, -11.0f, 12.0f, 9.0f, 15.0f), PartPose.offset((float)0.0f, (float)-12.0f, (float)-11.0f));
        head.addOrReplaceChild("sloped_head", CubeListBuilder.create().texOffs(54, 73).addBox(-10.0f, -8.5f, -0.5f, 11.0f, 9.0f, 12.0f), PartPose.offsetAndRotation((float)4.5f, (float)2.0f, (float)-6.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(0, 94).addBox(5.0f, -45.0f, -14.0f, 4.0f, 4.0f, 6.0f).texOffs(20, 96).addBox(8.0f, -44.0f, -9.0f, 3.0f, 4.0f, 4.0f).texOffs(34, 95).addBox(9.0f, -42.0f, -7.0f, 3.0f, 6.0f, 3.0f).texOffs(46, 98).addBox(10.5f, -38.0f, -9.0f, 3.0f, 3.0f, 3.0f).texOffs(58, 95).addBox(12.0f, -36.0f, -14.0f, 3.0f, 3.0f, 6.0f).texOffs(76, 95).addBox(13.0f, -40.0f, -16.0f, 3.0f, 6.0f, 3.0f).texOffs(88, 97).addBox(14.0f, -42.0f, -14.0f, 3.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)36.0f, (float)11.0f));
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().mirror().texOffs(0, 94).addBox(-9.0f, -45.0f, -14.0f, 4.0f, 4.0f, 6.0f).texOffs(20, 96).addBox(-11.0f, -44.0f, -9.0f, 3.0f, 4.0f, 4.0f).texOffs(34, 95).addBox(-12.0f, -42.0f, -7.0f, 3.0f, 6.0f, 3.0f).texOffs(46, 98).addBox(-13.5f, -38.0f, -9.0f, 3.0f, 3.0f, 3.0f).texOffs(58, 95).addBox(-15.0f, -36.0f, -14.0f, 3.0f, 3.0f, 6.0f).texOffs(76, 95).addBox(-16.0f, -40.0f, -16.0f, 3.0f, 6.0f, 3.0f).texOffs(88, 97).addBox(-17.0f, -42.0f, -14.0f, 3.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)36.0f, (float)11.0f));
        PartDefinition neck = partdefinition.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)-11.0f));
        neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(66, 37).addBox(-9.5f, -14.0f, -1.0f, 11.0f, 14.0f, 12.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)4.0f, (float)8.0f, (float)-3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("front_torso", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -32.0f, -15.0f, 18.0f, 15.0f, 15.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("back_torso", CubeListBuilder.create().texOffs(0, 30).addBox(-9.0f, -32.0f, 0.0f, 18.0f, 15.0f, 15.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(90, 20).addBox(-3.5f, -5.5f, -3.5f, 7.0f, 10.0f, 7.0f).texOffs(66, 18).addBox(-3.0f, 4.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset((float)6.0f, (float)7.0f, (float)-10.5f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().mirror().texOffs(90, 20).addBox(-3.5f, -5.5f, -3.5f, 7.0f, 10.0f, 7.0f).texOffs(66, 18).addBox(-3.0f, 4.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset((float)-6.0f, (float)7.0f, (float)-10.5f));
        partdefinition.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(90, 0).addBox(-3.5f, -4.5f, -6.0f, 7.0f, 10.0f, 10.0f).texOffs(66, 0).addBox(-3.0f, 5.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.offset((float)6.0f, (float)7.0f, (float)9.0f));
        partdefinition.addOrReplaceChild("right_back_leg", CubeListBuilder.create().mirror().texOffs(90, 0).addBox(-3.5f, -4.5f, -6.0f, 7.0f, 10.0f, 10.0f).texOffs(66, 0).addBox(-3.0f, 5.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.offset((float)-6.0f, (float)7.0f, (float)9.0f));
        CubeListBuilder wool = CubeListBuilder.create().texOffs(0, 104).addBox(-9.0f, -7.5f, 0.0f, 18.0f, 15.0f, 2.0f);
        for (int i = 0; i < 16; ++i) {
            partdefinition.addOrReplaceChild(QuestRamModel.getSegmentName(i), wool, PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition horns = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(64, 0).addBox(-9.0f, -11.0f, -1.0f, 4.0f, 10.0f, 10.0f).texOffs(48, 0).addBox(-13.0f, -11.0f, 5.0f, 4.0f, 4.0f, 4.0f).texOffs(92, 0).addBox(5.0f, -11.0f, -1.0f, 4.0f, 10.0f, 10.0f).texOffs(110, 0).addBox(9.0f, -11.0f, 5.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)-10.0f, (float)-8.0f));
        horns.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(74, 70).addBox(-6.0f, -2.0f, -13.0f, 12.0f, 8.0f, 15.0f).texOffs(42, 71).addBox(-6.0f, -5.0f, -9.0f, 12.0f, 3.0f, 11.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)3.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("front_torso", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -7.0f, -6.0f, 16.0f, 14.0f, 16.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(84, 93).addBox(-5.0f, -11.0f, -2.0f, 10.0f, 12.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-3.0f, (float)0.61086524f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("back_torso", CubeListBuilder.create().texOffs(0, 30).addBox(-8.0f, -7.0f, 8.0f, 16.0f, 14.0f, 16.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 60).addBox(-3.0f, 2.0f, -3.0f, 6.0f, 16.0f, 6.0f).texOffs(54, 20).addBox(-4.0f, -4.0f, -5.0f, 8.0f, 10.0f, 10.0f), PartPose.offset((float)-5.0f, (float)6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(24, 60).addBox(-3.0f, 2.0f, -3.0f, 6.0f, 16.0f, 6.0f).texOffs(90, 20).addBox(-4.0f, -4.0f, -5.0f, 8.0f, 10.0f, 10.0f), PartPose.offset((float)5.0f, (float)6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(0, 82).addBox(7.0f, 2.0f, -5.0f, 6.0f, 16.0f, 6.0f).texOffs(54, 50).addBox(6.0f, -4.0f, -7.0f, 8.0f, 10.0f, 10.0f), PartPose.offset((float)-16.0f, (float)6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(24, 82).addBox(-13.0f, 2.0f, -5.0f, 6.0f, 16.0f, 6.0f).texOffs(90, 50).addBox(-14.0f, -4.0f, -7.0f, 8.0f, 10.0f, 10.0f), PartPose.offset((float)16.0f, (float)6.0f, (float)0.0f));
        for (int i = 0; i < 16; ++i) {
            partdefinition.addOrReplaceChild("segment" + i, CubeListBuilder.create().texOffs(0, 112).addBox(-8.0f, -7.0f, 8.0f, 16.0f, 14.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)10.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private static LayerDefinition createJappaTrophy() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(74, 70).addBox(-6.0f, -4.0f, -10.0f, 12.0f, 8.0f, 15.0f).texOffs(42, 71).addBox(-6.0f, -7.0f, -6.0f, 12.0f, 3.0f, 11.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        head.addOrReplaceChild("horns", CubeListBuilder.create().texOffs(64, 0).addBox(-9.0f, -6.0f, -1.0f, 4.0f, 10.0f, 10.0f).texOffs(48, 0).addBox(-13.0f, -6.0f, 5.0f, 4.0f, 4.0f, 4.0f).texOffs(92, 0).addBox(5.0f, -6.0f, -1.0f, 4.0f, 10.0f, 10.0f).texOffs(110, 0).addBox(9.0f, -6.0f, 5.0f, 4.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.43633232f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private static String getSegmentName(int num) {
        return "segment" + num;
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        super.renderToBuffer(stack, builder, light, overlay, color);
        for (int i = 0; i < 16; ++i) {
            int dyeRgb = Sheep.getColor((DyeColor)DyeColor.byId((int)i));
            this.segments[i].render(stack, builder, light, overlay, dyeRgb);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        if (!JappaPackReloadListener.INSTANCE.isJappaPackLoaded()) {
            this.neck.yRot = this.head.yRot;
        }
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftBackLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightBackLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int count = ((QuestRam)entity).countColorsSet();
        boolean jappa = JappaPackReloadListener.INSTANCE.isJappaPackLoaded();
        this.head.z = -count - (jappa ? 20 : 11);
        this.neck.z = -count - (jappa ? 17 : 11);
        this.frontTorso.z = -count - (jappa ? 12 : 0);
        this.backTorso.z = count - (jappa ? 10 : 0);
        this.leftBackLeg.z = 9 + count;
        this.rightBackLeg.z = 9 + count;
        this.leftFrontLeg.z = -11 - count;
        this.rightFrontLeg.z = -11 - count;
        int segmentOffset = 0;
        for (int color : this.colorOrder) {
            if (((QuestRam)entity).isColorPresent(DyeColor.byId((int)color))) {
                this.segments[color].visible = true;
                this.segments[color].z = segmentOffset - count - (jappa ? 10 : 0);
                segmentOffset += 2;
                continue;
            }
            this.segments[color].visible = false;
        }
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.head.xRot = z * ((float)Math.PI / 180);
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        stack.scale(0.67f, 0.67f, 0.67f);
        if (!JappaPackReloadListener.INSTANCE.isJappaPackLoaded()) {
            stack.translate(0.0f, 0.5f, context != ItemDisplayContext.NONE ? 0.5f : 0.67f);
        }
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)QuestRamRenderer.TEXTURE));
        this.head.render(stack, consumer, light, overlay, color);
        stack.pushPose();
        stack.scale(1.025f, 1.025f, 1.025f);
        consumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)QuestRamRenderer.LINE_TEXTURE));
        this.head.render(stack, consumer, 0xF000F0, overlay, color);
        stack.popPose();
    }
}

