/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.MoonwormBlockEntity;
import twilightforest.client.BugModelAnimationHelper;

public class MoonwormModel
extends Model {
    private final ModelPart shape1;
    private final ModelPart shape2;
    private final ModelPart shape3;
    private final ModelPart head;

    public MoonwormModel(ModelPart root) {
        super(RenderType::entityCutoutNoCull);
        this.head = root.getChild("head");
        this.shape1 = root.getChild("shape1");
        this.shape2 = root.getChild("shape2");
        this.shape3 = root.getChild("shape3");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("shape1", CubeListBuilder.create().texOffs(0, 4).addBox(-1.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f), PartPose.offset((float)-1.0f, (float)7.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("shape2", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 4.0f), PartPose.offset((float)3.0f, (float)7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shape3", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)2.0f, (float)7.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)-3.0f, (float)7.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setRotationAngles(@Nullable MoonwormBlockEntity moonworm, float partialTime) {
        this.head.y = 7.0f;
        this.shape1.y = 7.0f;
        this.shape2.y = 7.0f;
        this.shape3.y = 7.0f;
        if (moonworm != null && moonworm.yawDelay == 0) {
            float time = (float)(moonworm.desiredYaw - moonworm.currentYaw) - partialTime;
            this.head.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f)));
            this.shape1.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f + 1.0f)));
            this.shape2.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f + 2.0f)));
            this.shape3.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f + 3.0f)));
        } else if (moonworm == null && BugModelAnimationHelper.yawWriggleDelay == 0) {
            float time = (float)(BugModelAnimationHelper.desiredRotation - BugModelAnimationHelper.currentRotation) - partialTime;
            this.head.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f)));
            this.shape1.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f + 1.0f)));
            this.shape2.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f + 2.0f)));
            this.shape3.y += Math.min(0.0f, Mth.sin((float)(time / 2.0f + 3.0f)));
        }
    }

    public void renderToBuffer(PoseStack ms, VertexConsumer buffer, int light, int overlay, int color) {
        this.shape1.render(ms, buffer, light, overlay, color);
        this.shape2.render(ms, buffer, light, overlay, color);
        this.shape3.render(ms, buffer, light, overlay, color);
        this.head.render(ms, buffer, light, overlay, color);
    }
}

