/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.IceCrystal;

public class IceCrystalModel
extends HierarchicalModel<IceCrystal> {
    private final ModelPart root;
    private final ModelPart[] spikes = new ModelPart[16];
    private boolean alive;

    public IceCrystalModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.root = root;
        for (int i = 0; i < this.spikes.length; ++i) {
            this.spikes[i] = root.getChild("spike_" + i);
        }
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        for (int i = 0; i < 16; ++i) {
            int spikeLength = i % 2 == 0 ? 6 : 8;
            PartDefinition spike = partdefinition.addOrReplaceChild("spike_" + i, CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.0f, -1.0f, 2.0f, (float)spikeLength, 2.0f), PartPose.ZERO);
            spike.addOrReplaceChild("cube_" + i, CubeListBuilder.create().texOffs(8, 16).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)spikeLength, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        for (ModelPart spike : this.spikes) {
            spike.render(stack, builder, light, overlay, FastColor.ARGB32.color((int)((int)((float)FastColor.ARGB32.alpha((int)color) * (this.alive ? 0.6f : 1.0f))), (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color)));
        }
    }

    public void setupAnim(IceCrystal entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(IceCrystal entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.alive = entity.isAlive();
        for (int i = 0; i < this.spikes.length; ++i) {
            this.spikes[i].xRot = Mth.sin((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
            this.spikes[i].yRot = ((float)entity.tickCount + partialTicks) / 5.0f;
            this.spikes[i].zRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
            this.spikes[i].xRot += (float)i * 0.3926991f;
            if (i % 4 == 0) {
                this.spikes[i].yRot += 1.0f;
                continue;
            }
            if (i % 4 != 2) continue;
            this.spikes[i].yRot -= 1.0f;
        }
    }
}

