/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.enums.BossVariant;

public class TrophyWallBlock
extends AbstractTrophyBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<TrophyWallBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BossVariant.CODEC.fieldOf("variant").forGetter(AbstractTrophyBlock::getVariant), (App)TrophyWallBlock.propertiesCodec()).apply((Applicative)instance, TrophyWallBlock::new));
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), (Object)Direction.WEST, (Object)Block.box((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)));
    private static final Map<Direction, VoxelShape> YETI_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)3.25, (double)4.0, (double)8.5, (double)12.75, (double)14.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)3.25, (double)4.0, (double)0.0, (double)12.75, (double)14.5, (double)7.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)3.25, (double)7.5, (double)14.5, (double)12.75), (Object)Direction.WEST, (Object)Block.box((double)8.5, (double)4.0, (double)3.25, (double)16.0, (double)14.5, (double)12.75)));

    public TrophyWallBlock(BossVariant variant, BlockBehaviour.Properties properties) {
        super(variant, 0, properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((AbstractTrophyBlock)state.getBlock()).getVariant() == BossVariant.UR_GHAST) {
            return TrophyBlock.GHAST_SHAPE;
        }
        if (((AbstractTrophyBlock)state.getBlock()).getVariant() == BossVariant.ALPHA_YETI) {
            return YETI_SHAPES.get(state.getValue((Property)FACING));
        }
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level getter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : adirection = context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal()) continue;
            Direction direction1 = direction.getOpposite();
            blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction1);
            if (getter.getBlockState(blockpos.relative(direction)).canBeReplaced(context)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }
}

