/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import twilightforest.enums.Diagonals;

public class SpiralBrickBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Diagonals> DIAGONAL = EnumProperty.create((String)"diagonal", Diagonals.class);
    public static final EnumProperty<Direction.Axis> AXIS_FACING = EnumProperty.create((String)"axis", Direction.Axis.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SpiralBrickBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(DIAGONAL, (Comparable)((Object)Diagonals.BOTTOM_RIGHT))).setValue(AXIS_FACING, (Comparable)Direction.Axis.X)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Diagonals convertVerticalDirectionToDiagonal(Direction facing) {
        return switch (facing) {
            default -> Diagonals.TOP_RIGHT;
            case Direction.SOUTH -> Diagonals.BOTTOM_LEFT;
            case Direction.EAST -> Diagonals.TOP_LEFT;
            case Direction.WEST -> Diagonals.BOTTOM_RIGHT;
        };
    }

    private static Diagonals getHorizontalDiagonalFromPlayerPlacement(LivingEntity placer, Direction facing, boolean upper) {
        return switch (facing) {
            case Direction.EAST, Direction.NORTH -> Diagonals.getDiagonalFromUpDownLeftRight(placer.getDirection() == facing, upper);
            case Direction.SOUTH, Direction.WEST -> Diagonals.getDiagonalFromUpDownLeftRight(placer.getDirection() != facing, upper);
            default -> Diagonals.BOTTOM_RIGHT;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS_FACING, DIAGONAL, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.isSecondaryUseActive()) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS_FACING, (Comparable)Direction.Axis.Y)).setValue(DIAGONAL, (Comparable)((Object)SpiralBrickBlock.convertVerticalDirectionToDiagonal(context.getHorizontalDirection())))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS_FACING, (Comparable)context.getHorizontalDirection().getAxis())).setValue(DIAGONAL, (Comparable)((Object)SpiralBrickBlock.getHorizontalDiagonalFromPlayerPlacement((LivingEntity)context.getPlayer(), context.getHorizontalDirection(), context.getClickLocation().y - (double)context.getClickedPos().getY() > 0.5)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS_FACING);
        if (rot == Rotation.CLOCKWISE_180 || axis == Direction.Axis.X && rot == Rotation.CLOCKWISE_90 || axis == Direction.Axis.Z && rot == Rotation.COUNTERCLOCKWISE_90) {
            state = (BlockState)state.setValue(DIAGONAL, (Comparable)((Object)Diagonals.mirror((Diagonals)((Object)state.getValue(DIAGONAL)), Mirror.LEFT_RIGHT)));
        }
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.getValue(AXIS_FACING)) {
                    case Direction.Axis.X -> (BlockState)state.setValue(AXIS_FACING, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)state.setValue(AXIS_FACING, (Comparable)Direction.Axis.X);
                    default -> state;
                };
            }
        }
        return state;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(DIAGONAL, (Comparable)((Object)Diagonals.mirrorOn((Direction.Axis)state.getValue(AXIS_FACING), (Diagonals)((Object)state.getValue(DIAGONAL)), mirror)));
    }
}

