/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import twilightforest.block.WaterloggedBlock;
import twilightforest.enums.HollowLogVariants;
import twilightforest.init.TFBlocks;
import twilightforest.util.AxisUtil;

public class HorizontalHollowLogBlock
extends Block
implements WaterloggedBlock {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<HollowLogVariants.Horizontal> VARIANT = EnumProperty.create((String)"variant", HollowLogVariants.Horizontal.class);
    private static final VoxelShape HOLLOW_SHAPE_X = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape HOLLOW_SHAPE_Z = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape CARPET_SHAPE_X = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape CARPET_SHAPE_Z = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape COLLISION_SHAPE_X = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape COLLISION_SHAPE_Z = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST);

    public HorizontalHollowLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.EMPTY)));
    }

    private static boolean canChangeVariant(HollowLogVariants.Horizontal variant, Level level, BlockPos pos, Direction.Axis axis) {
        return variant == HollowLogVariants.Horizontal.EMPTY || variant == HollowLogVariants.Horizontal.WATERLOGGED && level.getFluidState(pos.relative(AxisUtil.getAxisDirectionNegative(axis))).getType() != Fluids.WATER && level.getFluidState(pos.relative(AxisUtil.getAxisDirectionPositive(axis))).getType() != Fluids.WATER;
    }

    private static boolean isInside(HitResult result, Direction.Axis axis, BlockPos pos) {
        Vec3 vec = result.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (0.124 > vec.y || vec.y > 0.876) {
            return false;
        }
        return switch (axis) {
            case Direction.Axis.X -> {
                if (0.124 <= vec.z && vec.z <= 0.876) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> {
                if (0.124 <= vec.x && vec.x <= 0.876) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((HollowLogVariants.Horizontal)((Object)state.getValue(VARIANT))) {
            default -> throw new MatchException(null, null);
            case HollowLogVariants.Horizontal.EMPTY, HollowLogVariants.Horizontal.WATERLOGGED -> {
                switch ((Direction.Axis)state.getValue(HORIZONTAL_AXIS)) {
                    case X: {
                        yield HOLLOW_SHAPE_X;
                    }
                    case Z: {
                        yield HOLLOW_SHAPE_Z;
                    }
                }
                yield Shapes.block();
            }
            case HollowLogVariants.Horizontal.MOSS, HollowLogVariants.Horizontal.MOSS_AND_GRASS, HollowLogVariants.Horizontal.SNOW -> {
                switch ((Direction.Axis)state.getValue(HORIZONTAL_AXIS)) {
                    case X: {
                        yield CARPET_SHAPE_X;
                    }
                    case Z: {
                        yield CARPET_SHAPE_Z;
                    }
                }
                yield Shapes.block();
            }
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(HORIZONTAL_AXIS)) {
            case Direction.Axis.X -> COLLISION_SHAPE_X;
            case Direction.Axis.Z -> COLLISION_SHAPE_Z;
            default -> Shapes.empty();
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_AXIS, VARIANT});
    }

    @Override
    public boolean isStateWaterlogged(BlockState state) {
        return state.getValue(VARIANT) == HollowLogVariants.Horizontal.WATERLOGGED;
    }

    @Override
    public BlockState setWaterlog(BlockState prior, boolean doWater) {
        return (BlockState)prior.setValue(VARIANT, (Comparable)((Object)(doWater ? HollowLogVariants.Horizontal.WATERLOGGED : HollowLogVariants.Horizontal.EMPTY)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(HORIZONTAL_AXIS, (Comparable)context.getClickedFace().getAxis())).setValue(VARIANT, (Comparable)((Object)(context.getLevel().getBlockState(context.getClickedPos()).getFluidState().getType() == Fluids.WATER ? HollowLogVariants.Horizontal.WATERLOGGED : HollowLogVariants.Horizontal.EMPTY)));
    }

    public FluidState getFluidState(BlockState state) {
        return state.getValue(VARIANT) == HollowLogVariants.Horizontal.WATERLOGGED ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (this.isStateWaterlogged(state)) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, neighborState, accessor, pos, neighborPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction.Axis stateAxis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
        if (!HorizontalHollowLogBlock.isInside((HitResult)hit, stateAxis, pos)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        HollowLogVariants.Horizontal variant = (HollowLogVariants.Horizontal)((Object)state.getValue(VARIANT));
        if (stack.is(TFBlocks.MOSS_PATCH.asItem())) {
            if (HorizontalHollowLogBlock.canChangeVariant(variant, level, pos, stateAxis)) {
                level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.MOSS)), 3);
                level.playSound(null, pos, SoundEvents.MOSS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.consume(1, (LivingEntity)player);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        } else if (stack.is(Blocks.SHORT_GRASS.asItem())) {
            if (variant == HollowLogVariants.Horizontal.MOSS) {
                level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.MOSS_AND_GRASS)), 3);
                level.playSound(null, pos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.consume(1, (LivingEntity)player);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        } else if (stack.is(Items.SNOWBALL)) {
            if (HorizontalHollowLogBlock.canChangeVariant(variant, level, pos, stateAxis)) {
                level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.SNOW)), 3);
                level.playSound(null, pos, SoundEvents.SNOW_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.consume(1, (LivingEntity)player);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        } else if (stack.canPerformAction(ItemAbilities.SHOVEL_DIG)) {
            if (variant == HollowLogVariants.Horizontal.SNOW) {
                level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.EMPTY)), 3);
                level.playSound(null, pos, SoundEvents.SNOW_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)Items.SNOWBALL)));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        } else if (stack.canPerformAction(ItemAbilities.SHEARS_HARVEST) && (variant == HollowLogVariants.Horizontal.MOSS || variant == HollowLogVariants.Horizontal.MOSS_AND_GRASS)) {
            level.setBlock(pos, (BlockState)state.setValue(VARIANT, (Comparable)((Object)HollowLogVariants.Horizontal.EMPTY)), 3);
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)TFBlocks.MOSS_PATCH.get())));
                if (variant == HollowLogVariants.Horizontal.MOSS_AND_GRASS) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)Blocks.SHORT_GRASS)));
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        Direction.Axis stateAxis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
        if (!HorizontalHollowLogBlock.isInside((HitResult)hit, stateAxis, pos)) {
            return super.useWithoutItem(state, level, pos, player, hit);
        }
        if (player.isSecondaryUseActive() && player.getDirection().getAxis().equals((Object)stateAxis) && player.blockPosition().getY() == pos.getY() && !player.isFallFlying() && player.position().distanceTo(Vec3.atBottomCenterOf((Vec3i)pos)) < 0.81) {
            player.setPose(Pose.SWIMMING);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }
}

