/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.bookshelf.ChiseledCanopyShelfBlockEntity;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;
import twilightforest.network.ParticlePacket;

public class ChiseledCanopyShelfBlock
extends ChiseledBookShelfBlock {
    public static final BooleanProperty SPAWNER = BooleanProperty.create((String)"spawner");

    public ChiseledCanopyShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)SPAWNER, (Comparable)Boolean.valueOf(false));
        for (BooleanProperty booleanproperty : SLOT_OCCUPIED_PROPERTIES) {
            blockstate = (BlockState)blockstate.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(blockstate);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{SPAWNER}));
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (((Boolean)level.getBlockState(pos).getValue((Property)SPAWNER)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ChiseledCanopyShelfBlockEntity) {
                ChiseledCanopyShelfBlockEntity shelf = (ChiseledCanopyShelfBlockEntity)blockEntity;
                for (int i = 0; i < SLOT_OCCUPIED_PROPERTIES.size(); ++i) {
                    BooleanProperty property = (BooleanProperty)SLOT_OCCUPIED_PROPERTIES.get(i);
                    if (!state.hasProperty((Property)property) || !((Boolean)state.getValue((Property)property)).booleanValue()) continue;
                    shelf.getSpawner().attemptSpawnTome(i, serverLevel, pos, true, igniter, 5);
                }
                level.destroyBlock(pos, false);
            }
        }
        super.onCaughtFire(state, level, pos, face, igniter);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChiseledCanopyShelfBlockEntity) {
            ChiseledCanopyShelfBlockEntity shelf = (ChiseledCanopyShelfBlockEntity)blockEntity;
            if (stack.getItem() instanceof SpawnEggItem) {
                if (shelf.isEmpty()) {
                    return ItemInteractionResult.CONSUME;
                }
                level.playSound(null, pos, (SoundEvent)TFSounds.BOOKSHELF_CONVERTS.get(), SoundSource.BLOCKS, 0.35f, 0.6f + level.getRandom().nextFloat() * 0.4f);
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
        }
        if (((Boolean)state.getValue((Property)SPAWNER)).booleanValue()) {
            return ItemInteractionResult.FAIL;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (((Boolean)state.getValue((Property)SPAWNER)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)state.getValue((Property)SPAWNER)).booleanValue()) {
                level.playSound(null, pos, (SoundEvent)TFSounds.DEATH_TOME_DEATH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticlePacket particlePacket = new ParticlePacket();
                for (int i = 0; i < 20; ++i) {
                    particlePacket.queueParticle((ParticleOptions)ParticleTypes.POOF, false, (double)pos.getX() + 0.5 + level.getRandom().nextGaussian() * 0.02 * level.getRandom().nextGaussian(), (double)pos.getY() + level.getRandom().nextGaussian() * 0.02 * level.getRandom().nextGaussian(), (double)pos.getZ() + 0.5 + level.getRandom().nextGaussian() * 0.02 * level.getRandom().nextGaussian(), (double)0.15f * level.getRandom().nextGaussian(), (double)0.15f * level.getRandom().nextGaussian(), (double)0.15f * level.getRandom().nextGaussian());
                }
                PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)32.0, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        super.playerDestroy(level, player, pos, state, entity, stack);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChiseledCanopyShelfBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ChiseledCanopyShelfBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.CHISELED_CANOPY_BOOKSHELF.get()), ChiseledCanopyShelfBlockEntity::tick);
    }
}

