/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.beanification.internal;

import cpw.mods.jarhandling.SecureJar;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.fml.loading.modscan.Scanner;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DistAnnotationRetriever {
    @Nullable
    private Supplier<ModFileScanData> cachedBeanificationScan;

    public final Optional<ModFileScanData> getBeanificationScanData() {
        if (this.cachedBeanificationScan != null) {
            return Optional.ofNullable(this.cachedBeanificationScan.get());
        }
        FMLLoader.getGameLayer().configuration().modules().stream().filter(r -> r.name().equals("beanification")).findAny().ifPresentOrElse(module -> {
            SecureJar jar = SecureJar.from((Path[])new Path[]{Path.of(module.reference().location().orElseThrow())});
            ModFile modFile = new ModFile(jar, file -> null, new ModFileDiscoveryAttributes(null, null, null, null));
            ModFileScanData result = new Scanner(modFile).scan();
            this.cachedBeanificationScan = () -> result;
        }, () -> {
            this.cachedBeanificationScan = () -> null;
        });
        return Optional.ofNullable(this.cachedBeanificationScan.get());
    }

    @SafeVarargs
    public final Stream<ModFileScanData.AnnotationData> retrieve(ModFileScanData scanData, ElementType elementType, Class<? extends Annotation> ... types) {
        ArrayList<Class<? extends Annotation>> t = new ArrayList<Class<? extends Annotation>>();
        for (Class<? extends Annotation> type2 : types) {
            t.add(type2);
        }
        return t.stream().flatMap(type -> {
            Stream modScan = scanData.getAnnotatedBy(type, elementType);
            Stream combinedScan = this.getBeanificationScanData().map(s -> Stream.concat(s.getAnnotatedBy(type, elementType), modScan)).orElse(modScan);
            return combinedScan.filter(annotation -> {
                Object patt0$temp = annotation.annotationData().get("dist");
                if (patt0$temp instanceof ArrayList) {
                    ArrayList list = (ArrayList)patt0$temp;
                    if (list.isEmpty()) {
                        return true;
                    }
                    for (Object o : list) {
                        ModAnnotation.EnumHolder e;
                        if (!(o instanceof ModAnnotation.EnumHolder) || Dist.valueOf((String)(e = (ModAnnotation.EnumHolder)o).value()) != FMLEnvironment.dist) continue;
                        return true;
                    }
                } else {
                    return true;
                }
                return false;
            });
        });
    }
}

